/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxOutEndingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(StaxOutEndingInterceptor.class);
    private String outStreamHolder;

    public StaxOutEndingInterceptor(String outStreamHolder) {
        super("pre-stream-ending");
        this.getAfter().add(AttachmentOutInterceptor.AttachmentOutEndingInterceptor.class.getName());
        this.outStreamHolder = outStreamHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) throws Fault {
        try {
            OutputStream os;
            XMLStreamWriter xtw = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            if (xtw != null) {
                try {
                    xtw.writeEndDocument();
                    xtw.flush();
                }
                finally {
                    StaxUtils.close((XMLStreamWriter)xtw);
                }
            }
            if ((os = (OutputStream)message.get((Object)this.outStreamHolder)) != null) {
                message.setContent(OutputStream.class, (Object)os);
            }
            message.removeContent(XMLStreamWriter.class);
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
    }
}

