/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.http.HttpConnectionManager;
import org.mule.transport.http.HttpConstants;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.http.ntlm.NTLMScheme;
import org.mule.transport.tcp.TcpConnector;
import org.mule.util.MapUtils;

public class HttpConnector
extends TcpConnector {
    public static final String HTTP = "http";
    public static final String HTTP_PREFIX = "http.";
    public static final String HTTP_STATUS_PROPERTY = "http.status";
    public static final String HTTP_VERSION_PROPERTY = "http.version";
    @Deprecated
    public static final String HTTP_CUSTOM_HEADERS_MAP_PROPERTY = "http.custom.headers";
    public static final String HTTP_HEADERS = "http.headers";
    public static final String HTTP_QUERY_PARAMS = "http.query.params";
    public static final String HTTP_QUERY_STRING = "http.query.string";
    public static final String HTTP_METHOD_PROPERTY = "http.method";
    public static final String HTTP_REQUEST_PROPERTY = "http.request";
    public static final String HTTP_REQUEST_PATH_PROPERTY = "http.request.path";
    public static final String HTTP_CONTEXT_PATH_PROPERTY = "http.context.path";
    public static final String HTTP_CONTEXT_URI_PROPERTY = "http.context.uri";
    public static final String HTTP_RELATIVE_PATH_PROPERTY = "http.relative.path";
    public static final String HTTP_SERVLET_REQUEST_PROPERTY = "http.servlet.request";
    public static final String HTTP_SERVLET_RESPONSE_PROPERTY = "http.servlet.response";
    public static final String HTTP_PARAMS_PROPERTY = "http.params";
    public static final String HTTP_GET_BODY_PARAM_PROPERTY = "http.get.body.param";
    public static final String DEFAULT_HTTP_GET_BODY_PARAM_PROPERTY = "body";
    public static final String HTTP_POST_BODY_PARAM_PROPERTY = "http.post.body.param";
    public static final String HTTP_DISABLE_STATUS_CODE_EXCEPTION_CHECK = "http.disable.status.code.exception.check";
    public static final String HTTP_ENCODE_PARAMVALUE = "http.encode.paramvalue";
    public static final Set<String> HTTP_INBOUND_PROPERTIES;
    public static final String HTTP_COOKIE_SPEC_PROPERTY = "cookieSpec";
    public static final String HTTP_COOKIES_PROPERTY = "cookies";
    public static final String HTTP_ENABLE_COOKIES_PROPERTY = "enableCookies";
    public static final String COOKIE_SPEC_NETSCAPE = "netscape";
    public static final String COOKIE_SPEC_RFC2109 = "rfc2109";
    public static final String ROOT_PATH = "/";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 2000;
    private String proxyHostname = null;
    private int proxyPort = 80;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private boolean proxyNtlmAuthentication;
    private String cookieSpec;
    private boolean enableCookies = false;
    protected org.apache.commons.httpclient.HttpConnectionManager clientConnectionManager;
    private IdleConnectionTimeoutThread connectionCleaner;
    private boolean disableCleanupThread;
    private HttpConnectionManager connectionManager;

    public HttpConnector(MuleContext context) {
        super(context);
    }

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        if (this.clientConnectionManager == null) {
            this.clientConnectionManager = new MultiThreadedHttpConnectionManager();
            String prop = System.getProperty("mule.http.disableCleanupThread");
            boolean bl = this.disableCleanupThread = prop != null && prop.equals("true");
            if (!this.disableCleanupThread) {
                this.connectionCleaner = new IdleConnectionTimeoutThread();
                this.connectionCleaner.setName("HttpClient-connection-cleaner-" + this.getName());
                this.connectionCleaner.addConnectionManager(this.clientConnectionManager);
                this.connectionCleaner.start();
            }
            HttpConnectionManagerParams params = new HttpConnectionManagerParams();
            if (this.getSendBufferSize() != -1) {
                params.setSendBufferSize(this.getSendBufferSize());
            }
            if (this.getReceiveBufferSize() != -1) {
                params.setReceiveBufferSize(this.getReceiveBufferSize());
            }
            if (this.getClientSoTimeout() != -1) {
                params.setSoTimeout(this.getClientSoTimeout());
            }
            if (this.getSocketSoLinger() != -1) {
                params.setLinger(this.getSocketSoLinger());
            }
            params.setTcpNoDelay(this.isSendTcpNoDelay());
            params.setMaxTotalConnections(this.dispatchers.getMaxTotal());
            params.setDefaultMaxConnectionsPerHost(this.dispatchers.getMaxTotal());
            if (this.getConnectionTimeout() != -1) {
                params.setConnectionTimeout(this.getConnectionTimeout());
            } else {
                params.setConnectionTimeout(2000);
            }
            this.clientConnectionManager.setParams(params);
        }
        if (this.connectionManager == null) {
            try {
                this.connectionManager = new HttpConnectionManager(this, this.getReceiverWorkManager());
            }
            catch (MuleException e) {
                throw new InitialisationException(CoreMessages.createStaticMessage((String)"failed creating http connection manager"), (Initialisable)this);
            }
        }
    }

    protected void doDispose() {
        if (!this.disableCleanupThread) {
            this.connectionCleaner.shutdown();
            if (!this.muleContext.getConfiguration().isStandalone()) {
                MultiThreadedHttpConnectionManager.shutdownAll();
            }
        }
        if (this.connectionManager != null) {
            this.connectionManager.dispose();
            this.connectionManager = null;
        }
        super.doDispose();
    }

    protected void doStop() throws MuleException {
        this.connectionManager.dispose();
        this.connectionManager = null;
    }

    protected void doStart() throws MuleException {
        super.doStart();
        if (this.connectionManager == null) {
            this.connectionManager = new HttpConnectionManager(this, this.getReceiverWorkManager());
        }
    }

    public void registerListener(InboundEndpoint endpoint, MessageProcessor listener, FlowConstruct flowConstruct) throws Exception {
        Map endpointProperties;
        if (endpoint != null && (endpointProperties = endpoint.getProperties()) != null) {
            HashMap newProperties = new HashMap(endpointProperties.size());
            for (Map.Entry entry : endpointProperties.entrySet()) {
                Object key = entry.getKey();
                String normalizedKey = HttpConstants.ALL_HEADER_NAMES.get(key);
                if (normalizedKey != null) {
                    key = normalizedKey;
                }
                newProperties.put(key, entry.getValue());
            }
            endpoint.getProperties().clear();
            endpoint.getProperties().putAll(newProperties);
        }
        super.registerListener(endpoint, listener, flowConstruct);
    }

    protected Object getReceiverKey(FlowConstruct flowConstruct, InboundEndpoint endpoint) {
        String key = endpoint.getEndpointURI().toString();
        int i = key.indexOf(63);
        if (i > -1) {
            key = key.substring(0, i);
        }
        return key;
    }

    public String getProtocol() {
        return HTTP;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyHostname(String host) {
        this.proxyHostname = host;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string;
    }

    public Map getReceivers() {
        return this.receivers;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public void setCookieSpec(String cookieSpec) {
        if (!COOKIE_SPEC_NETSCAPE.equalsIgnoreCase(cookieSpec) && !COOKIE_SPEC_RFC2109.equalsIgnoreCase(cookieSpec)) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue((String)HTTP_COOKIE_SPEC_PROPERTY, (Object)cookieSpec).toString());
        }
        this.cookieSpec = cookieSpec;
    }

    public boolean isEnableCookies() {
        return this.enableCookies;
    }

    public void setEnableCookies(boolean enableCookies) {
        this.enableCookies = enableCookies;
    }

    public org.apache.commons.httpclient.HttpConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(org.apache.commons.httpclient.HttpConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    protected HttpClient doClientConnect() throws Exception {
        HttpState state = new HttpState();
        if (this.getProxyUsername() != null) {
            Object credentials = this.isProxyNtlmAuthentication() ? new NTCredentials(this.getProxyUsername(), this.getProxyPassword(), this.getProxyHostname(), "") : new UsernamePasswordCredentials(this.getProxyUsername(), this.getProxyPassword());
            AuthScope authscope = new AuthScope(this.getProxyHostname(), this.getProxyPort());
            state.setProxyCredentials(authscope, (Credentials)credentials);
        }
        HttpClient client = new HttpClient();
        client.setState(state);
        client.setHttpConnectionManager(this.getClientConnectionManager());
        return client;
    }

    protected void setupClientAuthorization(MuleEvent event, HttpMethod httpMethod, HttpClient client, ImmutableEndpoint endpoint) throws UnsupportedEncodingException {
        httpMethod.setDoAuthentication(true);
        client.getParams().setAuthenticationPreemptive(true);
        if (event != null && event.getCredentials() != null) {
            MuleMessage msg = event.getMessage();
            String authScopeHost = (String)msg.getOutboundProperty("http.auth.scope.host", (Object)event.getMessageSourceURI().getHost());
            int authScopePort = (Integer)msg.getOutboundProperty("http.auth.scope.port", (Object)event.getMessageSourceURI().getPort());
            String authScopeRealm = (String)msg.getOutboundProperty("http.auth.scope.realm", (Object)AuthScope.ANY_REALM);
            String authScopeScheme = (String)msg.getOutboundProperty("http.auth.scope.scheme", (Object)AuthScope.ANY_SCHEME);
            client.getState().setCredentials(new AuthScope(authScopeHost, authScopePort, authScopeRealm, authScopeScheme), (Credentials)new UsernamePasswordCredentials(event.getCredentials().getUsername(), new String(event.getCredentials().getPassword())));
        } else if (endpoint.getEndpointURI().getUserInfo() != null && endpoint.getProperty((Object)"Authorization") == null) {
            StringBuilder header = new StringBuilder(128);
            header.append("Basic ");
            header.append(new String(Base64.encodeBase64((byte[])endpoint.getEndpointURI().getUserInfo().getBytes(endpoint.getEncoding()))));
            httpMethod.addRequestHeader("Authorization", header.toString());
        } else if (event != null && event.getMessage().getOutboundProperty("Authorization") != null && httpMethod.getRequestHeader("Authorization") == null) {
            String auth = (String)event.getMessage().getOutboundProperty("Authorization");
            httpMethod.addRequestHeader("Authorization", auth);
        } else {
            client.getParams().setAuthenticationPreemptive(false);
        }
    }

    public static String normalizeUrl(String url) {
        if (url == null) {
            url = ROOT_PATH;
        } else if (!url.startsWith(ROOT_PATH)) {
            url = ROOT_PATH + url;
        }
        return url;
    }

    public boolean isProxyNtlmAuthentication() {
        return this.proxyNtlmAuthentication;
    }

    public void setProxyNtlmAuthentication(boolean proxyNtlmAuthentication) {
        this.proxyNtlmAuthentication = proxyNtlmAuthentication;
    }

    public void connect(EndpointURI endpointURI) {
        this.connectionManager.addConnection(endpointURI);
    }

    public void disconnect(EndpointURI endpointURI) {
        this.connectionManager.removeConnection(endpointURI);
    }

    public HttpMessageReceiver lookupReceiver(Socket socket, RequestLine requestLine) throws NoReceiverForEndpointException {
        HttpMessageReceiver receiver;
        int port = ((InetSocketAddress)socket.getLocalSocketAddress()).getPort();
        String host = null;
        for (MessageReceiver messageReceiver : this.receivers.values()) {
            if (messageReceiver.getEndpointURI().getPort() != port) continue;
            host = messageReceiver.getEndpointURI().getHost();
            break;
        }
        if (host == null) {
            String url = requestLine.getUrlWithoutParams();
            throw new NoReceiverForEndpointException(HttpMessages.noReceiverFoundForUrl(url));
        }
        String requestUriWithoutParams = requestLine.getUrlWithoutParams();
        StringBuilder requestUri = new StringBuilder(80);
        if (requestUriWithoutParams.indexOf("://") == -1) {
            requestUri.append(this.getProtocol()).append("://").append(host).append(':').append(port);
            if (!ROOT_PATH.equals(requestUriWithoutParams)) {
                requestUri.append(requestUriWithoutParams);
            }
        }
        String uriStr = requestUri.toString();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Looking up receiver on connector: " + this.getName() + " with URI key: " + requestUri.toString()));
        }
        if ((receiver = (HttpMessageReceiver)this.lookupReceiver(uriStr)) == null && !ROOT_PATH.equals(requestUriWithoutParams)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Secondary lookup of receiver on connector: " + this.getName() + " with URI key: " + requestUri.toString()));
            }
            if ((receiver = (HttpMessageReceiver)HttpConnector.findReceiverByStem(this.getReceivers(), uriStr)) == null && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("No receiver found with secondary lookup on connector: " + this.getName() + " with URI key: " + requestUri.toString()));
                this.logger.warn((Object)("Receivers on connector are: " + MapUtils.toString((Map)this.getReceivers(), (boolean)true)));
            }
        }
        if (receiver == null) {
            throw new NoReceiverForEndpointException(HttpMessages.noReceiverFoundForUrl(requestUriWithoutParams));
        }
        return receiver;
    }

    @Deprecated
    public HttpMessageReceiver lookupReceiver(Socket socket, HttpRequest request) {
        try {
            return this.lookupReceiver(socket, request.getRequestLine());
        }
        catch (NoReceiverForEndpointException e) {
            this.logger.debug((Object)("No receiver found: " + e.getMessage()));
            return null;
        }
    }

    public static MessageReceiver findReceiverByStem(Map<Object, MessageReceiver> receivers, String uriStr) {
        int match = 0;
        MessageReceiver receiver = null;
        for (Map.Entry<Object, MessageReceiver> e : receivers.entrySet()) {
            String key = (String)e.getKey();
            MessageReceiver candidate = e.getValue();
            if (!uriStr.startsWith(key) || match >= key.length()) continue;
            match = key.length();
            receiver = candidate;
        }
        return receiver;
    }

    protected ServerSocket getServerSocket(URI uri) throws IOException {
        return super.getServerSocket(uri);
    }

    @Deprecated
    public boolean isKeepSendSocketOpen() {
        return super.isKeepSendSocketOpen();
    }

    @Deprecated
    public void setKeepSendSocketOpen(boolean keepSendSocketOpen) {
        this.logger.warn((Object)"keepSendSocketOpen attribute is deprecated, use keepAlive in the outbound endpoint instead");
        super.setKeepSendSocketOpen(keepSendSocketOpen);
    }

    static {
        HashSet<String> props = new HashSet<String>();
        props.add(HTTP_CONTEXT_PATH_PROPERTY);
        props.add(HTTP_GET_BODY_PARAM_PROPERTY);
        props.add(HTTP_METHOD_PROPERTY);
        props.add(HTTP_PARAMS_PROPERTY);
        props.add(HTTP_POST_BODY_PARAM_PROPERTY);
        props.add(HTTP_REQUEST_PROPERTY);
        props.add(HTTP_REQUEST_PATH_PROPERTY);
        props.add(HTTP_STATUS_PROPERTY);
        props.add(HTTP_VERSION_PROPERTY);
        props.add(HTTP_ENCODE_PARAMVALUE);
        HTTP_INBOUND_PROPERTIES = props;
        AuthPolicy.registerAuthScheme((String)"NTLM", NTLMScheme.class);
    }
}

