/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.mule.util.MapUtils;

public class HttpConstants {
    public static final String HTTP10 = "HTTP/1.0";
    public static final String HTTP1X = "HTTP/1.x";
    public static final String HTTP11 = "HTTP/1.1";
    public static final String DEFAULT_HTTP_VERSION = "HTTP/1.1";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_PATCH = "PATCH";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_TRACE = "TRACE";
    public static final String METHOD_CONNECT = "CONNECT";
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy hh:mm:ss zzz";
    public static final String DATE_FORMAT_RFC822 = "EEE, dd MMM yyyy HH:mm:ss Z";
    public static final String CRLF = "\r\n";
    public static final String HEADER_CONTENT_SEPARATOR = "\r\n\r\n";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String FORM_URLENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HEADER_AGE = "Age";
    public static final String HEADER_ALLOW = "Allow";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_CONNECTION = "Connection";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_LANGUAGE = "Content-Language";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_LOCATION = "Content-Location";
    public static final String HEADER_CONTENT_MD5 = "Content-MD5";
    public static final String HEADER_CONTENT_RANGE = "Content-Range";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_COOKIE = "Cookie";
    public static final String HEADER_COOKIE_SET = "Set-Cookie";
    public static final String HEADER_DATE = "Date";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_EXPECT = "Expect";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_FROM = "From";
    public static final String HEADER_HOST = "Host";
    public static final String HEADER_IF_MATCH = "If-Match";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_IF_RANGE = "If-Range";
    public static final String HEADER_IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String HEADER_KEEP_ALIVE = "Keep-Alive";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_MAX_FORWARDS = "Max-Forwards";
    public static final String HEADER_PRAGMA = "Pragma";
    public static final String HEADER_PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String HEADER_RANGE = "Range";
    public static final String HEADER_REFERER = "Referer";
    public static final String HEADER_RETRY_AFTER = "Retry-After";
    public static final String HEADER_SERVER = "Server";
    public static final String HEADER_SLUG = "Slug";
    public static final String HEADER_TE = "TE";
    public static final String HEADER_TRAILER = "Trailer";
    public static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String HEADER_UPGRADE = "Upgrade";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_VARY = "Vary";
    public static final String HEADER_VIA = "Via";
    public static final String HEADER_WARNING = "Warning";
    public static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HEADER_EXPECT_CONTINUE_REQUEST_VALUE = "100-continue";
    public static final String TRANSFER_ENCODING_CHUNKED = "chunked";
    public static final String CUSTOM_HEADER_PREFIX = "X-";
    public static final String X_PROPERTY_PREFIX = "X-MULE_";
    public static final String HEADER_MULE_SESSION = "X-MULE_SESSION";
    public static final Map<String, String> REQUEST_HEADER_NAMES;
    public static final Map<String, String> RESPONSE_HEADER_NAMES;
    public static final Map<String, String> GENERAL_AND_ENTITY_HEADER_NAMES;
    public static final Map<String, String> ALL_HEADER_NAMES;
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_PROCESSING = 102;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTI_STATUS = 207;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_TOO_LONG = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INSUFFICIENT_SPACE_ON_RESOURCE = 419;
    public static final int SC_METHOD_FAILURE = 420;
    public static final int SC_UNPROCESSABLE_ENTITY = 422;
    public static final int SC_LOCKED = 423;
    public static final int SC_FAILED_DEPENDENCY = 424;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int SC_INSUFFICIENT_STORAGE = 507;

    static {
        Object[] strings = new String[]{HEADER_ACCEPT, HEADER_ACCEPT_CHARSET, HEADER_ACCEPT_ENCODING, HEADER_ACCEPT_LANGUAGE, HEADER_AUTHORIZATION, HEADER_COOKIE, HEADER_EXPECT, HEADER_FROM, HEADER_HOST, HEADER_IF_MATCH, HEADER_IF_MODIFIED_SINCE, HEADER_IF_NONE_MATCH, HEADER_IF_RANGE, HEADER_IF_UNMODIFIED_SINCE, HEADER_MAX_FORWARDS, HEADER_PROXY_AUTHORIZATION, HEADER_RANGE, HEADER_REFERER, HEADER_TE, HEADER_USER_AGENT, HEADER_SLUG};
        REQUEST_HEADER_NAMES = Collections.unmodifiableMap(MapUtils.mapWithKeysAndValues(CaseInsensitiveMap.class, (Object[])strings, (Object[])strings));
        strings = new String[]{HEADER_ACCEPT_RANGES, HEADER_AGE, HEADER_CONTENT_DISPOSITION, HEADER_COOKIE_SET, HEADER_ETAG, HEADER_LOCATION, HEADER_PROXY_AUTHENTICATE, HEADER_RETRY_AFTER, HEADER_SERVER, HEADER_VARY, HEADER_WWW_AUTHENTICATE, HEADER_TRANSFER_ENCODING};
        RESPONSE_HEADER_NAMES = Collections.unmodifiableMap(MapUtils.mapWithKeysAndValues(CaseInsensitiveMap.class, (Object[])strings, (Object[])strings));
        strings = new String[]{HEADER_ALLOW, HEADER_CACHE_CONTROL, HEADER_CONNECTION, HEADER_CONTENT_ENCODING, HEADER_CONTENT_LANGUAGE, HEADER_CONTENT_LENGTH, HEADER_CONTENT_LOCATION, HEADER_CONTENT_MD5, HEADER_CONTENT_RANGE, HEADER_CONTENT_TYPE, HEADER_DATE, HEADER_EXPIRES, HEADER_KEEP_ALIVE, HEADER_LAST_MODIFIED, HEADER_PRAGMA, HEADER_TRAILER, HEADER_UPGRADE, HEADER_VIA, HEADER_WARNING};
        GENERAL_AND_ENTITY_HEADER_NAMES = Collections.unmodifiableMap(MapUtils.mapWithKeysAndValues(CaseInsensitiveMap.class, (Object[])strings, (Object[])strings));
        Map allHeaders = MapUtils.mapWithKeysAndValues(CaseInsensitiveMap.class, (Object[])strings, (Object[])strings);
        allHeaders.putAll(REQUEST_HEADER_NAMES);
        allHeaders.putAll(RESPONSE_HEADER_NAMES);
        ALL_HEADER_NAMES = Collections.unmodifiableMap(allHeaders);
    }
}

