/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.sftp.ErrorOccurredDecorator;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpConnector;

public class SftpInputStream
extends BufferedInputStream
implements ErrorOccurredDecorator {
    private final Log logger = LogFactory.getLog(this.getClass());
    private SftpClient client;
    private boolean autoDelete = true;
    private String fileName;
    private boolean errorOccured = false;
    private ImmutableEndpoint endpoint;
    private static final int LOG_BYTE_INTERVAL = 10000000;
    private long bytesRead = 0L;
    private long nextLevelToLogBytesRead = 10000000L;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public SftpInputStream(SftpClient client, InputStream is, String fileName, boolean autoDelete, ImmutableEndpoint endpoint) throws Exception {
        super(is);
        this.client = client;
        this.fileName = fileName;
        this.autoDelete = autoDelete;
        this.endpoint = endpoint;
    }

    @Override
    public synchronized int read() throws IOException {
        this.logReadBytes(1);
        return super.read();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.logReadBytes(len);
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.logReadBytes(b.length);
        return super.read(b);
    }

    @Override
    public void close() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing the stream for the file " + this.fileName));
        }
        try {
            super.close();
            if (this.autoDelete && !this.errorOccured) {
                this.client.deleteFile(this.fileName);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Error occured while closing file " + this.fileName), (Throwable)e);
            throw e;
        }
        finally {
            try {
                ((SftpConnector)this.endpoint.getConnector()).releaseClient(this.endpoint, this.client);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setErrorOccurred() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"setErrorOccurred() called");
        }
        this.errorOccured = true;
    }

    public String toString() {
        return "SftpInputStream{fileName='" + this.fileName + '\'' + " from endpoint=" + this.endpoint.getEndpointURI() + '}';
    }

    private void logReadBytes(int newBytesRead) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.bytesRead += (long)newBytesRead;
        if (this.bytesRead >= this.nextLevelToLogBytesRead) {
            this.logger.debug((Object)("Read " + this.bytesRead + " bytes and couting..."));
            this.nextLevelToLogBytesRead += 10000000L;
        }
    }
}

