/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.sqlstrategy;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.JdbcUtils;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategy;
import org.mule.util.ArrayUtils;

public class SelectSqlStatementStrategy
implements SqlStatementStrategy {
    protected transient Logger logger = Logger.getLogger(this.getClass());

    @Override
    public MuleMessage executeStatement(JdbcConnector connector, ImmutableEndpoint endpoint, MuleEvent event, long timeout, Connection connection) throws Exception {
        Object result;
        Object[] params;
        ArrayList<String> ackParams;
        String ackStmt;
        block11: {
            this.logger.debug((Object)("Trying to receive a message with a timeout of " + timeout));
            String[] stmts = connector.getReadAndAckStatements(endpoint);
            String readStmt = stmts[0];
            ackStmt = stmts[1];
            ArrayList<String> readParams = new ArrayList<String>();
            ackParams = new ArrayList<String>();
            readStmt = connector.parseStatement(readStmt, readParams);
            ackStmt = connector.parseStatement(ackStmt, ackParams);
            long t0 = System.currentTimeMillis();
            if (timeout < 0L) {
                timeout = Long.MAX_VALUE;
            }
            while (true) {
                params = connector.getParams(endpoint, readParams, event != null ? event.getMessage() : null, endpoint.getEndpointURI().getAddress());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("SQL QUERY: " + readStmt + ", params = " + ArrayUtils.toString((Object)params)));
                }
                if ((result = connector.getQueryRunnerFor(endpoint).query(connection, readStmt, connector.getResultSetHandler(), params)) != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("SQL query received a result: " + result));
                    } else if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)"SQL query received a result");
                    }
                    break block11;
                }
                long sleep = Math.min(connector.getPollingFrequency(), timeout - (System.currentTimeMillis() - t0));
                if (sleep <= 0L) break;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No results, sleeping for " + sleep));
                }
                Thread.sleep(sleep);
            }
            this.logger.debug((Object)"Timeout");
            JdbcUtils.rollbackAndClose(connection);
            return null;
        }
        if (ackStmt != null) {
            int nbRows;
            params = connector.getParams(endpoint, ackParams, (MuleMessage)new DefaultMuleMessage(result, (Map)null, endpoint.getMuleContext()), ackStmt);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SQL UPDATE: " + ackStmt + ", params = " + ArrayUtils.toString((Object)params)));
            }
            if ((nbRows = connector.getQueryRunnerFor(endpoint).update(connection, ackStmt, params)) != 1) {
                this.logger.warn((Object)("Row count for ack should be 1 and not " + nbRows));
            }
        }
        DefaultMuleMessage message = null;
        message = event != null ? new DefaultMuleMessage(result, event.getMessage(), endpoint.getMuleContext()) : new DefaultMuleMessage(result, endpoint.getMuleContext());
        return message;
    }
}

