/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.task.Participation;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetParticipantsCmd
extends AbstractCommand<List<Participation>> {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String swimlaneId;

    public GetParticipantsCmd(String taskId, String swimlaneId) {
        if (taskId == null) {
            throw new JbpmException("taskId is null");
        }
        this.taskId = taskId;
        this.swimlaneId = swimlaneId;
    }

    public List<Participation> execute(Environment environment) throws Exception {
        Criteria criteria = ((Session)environment.get(Session.class)).createCriteria(ParticipationImpl.class);
        if (this.taskId != null) {
            criteria.add((Criterion)Restrictions.eq((String)"task.dbid", (Object)Long.parseLong(this.taskId)));
        } else if (this.swimlaneId != null) {
            criteria.add((Criterion)Restrictions.eq((String)"swimlane.dbid", (Object)Long.parseLong(this.swimlaneId)));
        } else {
            throw new JbpmException("no task nor swimlane specified");
        }
        List participations = criteria.list();
        return CollectionUtil.checkList(participations, Participation.class);
    }
}

