/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.el;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.el.ELException;
import javax.el.ExpressionFactory;

class FactoryFinder {
    private FactoryFinder() {
    }

    private static ExpressionFactory newInstance(Properties properties, String className, ClassLoader classLoader) {
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(className.trim());
        }
        catch (ClassNotFoundException e) {
            throw new ELException("expression factory class not found", (Throwable)e);
        }
        Class<ExpressionFactory> factoryClass = clazz.asSubclass(ExpressionFactory.class);
        try {
            if (properties != null) {
                try {
                    Constructor<ExpressionFactory> constructor = factoryClass.getConstructor(Properties.class);
                    try {
                        return constructor.newInstance(properties);
                    }
                    catch (InvocationTargetException e) {
                        throw new ELException(constructor + " threw exception", e.getCause());
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            return factoryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ELException("failed to instantiate: " + factoryClass, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ELException(FactoryFinder.class + " has no access to " + factoryClass, (Throwable)e);
        }
    }

    public static Object find(String serviceName, String defaultServiceProvider, Properties properties, String propertyFileName) {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException e) {
            classLoader = ExpressionFactory.class.getClassLoader();
        }
        String className = FactoryFinder.getClassName(serviceName, defaultServiceProvider, propertyFileName, classLoader);
        return FactoryFinder.newInstance(properties, className, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getClassName(String serviceName, String defaultServiceProvider, String propertyFileName, ClassLoader classLoader) {
        block36: {
            InputStream serviceInput = classLoader.getResourceAsStream("META-INF/services/" + serviceName);
            if (serviceInput != null) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(serviceInput, "UTF-8"));
                    String className = reader.readLine();
                    if (className != null) {
                        String string2 = className;
                        return string2;
                    }
                    reader.close();
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        serviceInput.close();
                    }
                    catch (IOException e) {}
                }
            }
            try {
                File propertyFile;
                String home = System.getProperty("java.home");
                if (home == null || !(propertyFile = new File(home + File.separator + "lib", propertyFileName)).canRead()) break block36;
                FileInputStream propertyInput = null;
                try {
                    propertyInput = new FileInputStream(propertyFile);
                    Properties props = new Properties();
                    props.load(propertyInput);
                    String className = props.getProperty(ExpressionFactory.class.getName());
                    if (className != null) {
                        String string = className;
                        return string;
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (propertyInput != null) {
                        try {
                            ((InputStream)propertyInput).close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        try {
            String className = System.getProperty(serviceName);
            if (className == null) return defaultServiceProvider;
            return className;
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return defaultServiceProvider;
    }
}

