/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.events;

import java.io.Serializable;
import org.hibernate.Session;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.events.ActivityEnd;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskInstanceImpl;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskSkip
extends ActivityEnd {
    private static final long serialVersionUID = 1L;
    protected String outcome;

    public TaskSkip(TaskImpl taskImpl, String outcome) {
        this(outcome);
    }

    public TaskSkip(String outcome) {
        this.outcome = outcome;
    }

    @Override
    protected void updateHistoryActivityInstance(HistoryActivityInstanceImpl historyActivityInstance) {
        super.updateHistoryActivityInstance(historyActivityInstance);
        Session session = EnvironmentImpl.getFromCurrent(Session.class);
        Long historyTaskInstanceId = this.execution.getHistoryActivityInstanceDbid();
        HistoryTaskInstanceImpl historyTaskInstance = (HistoryTaskInstanceImpl)session.load(HistoryTaskInstanceImpl.class, (Serializable)historyTaskInstanceId);
        historyTaskInstance.setEndTime(Clock.getTime());
        historyTaskInstance.setTransitionName(this.outcome);
        HistoryTaskImpl historyTask = historyTaskInstance.getHistoryTask();
        historyTask.setOutcome(this.outcome);
        historyTask.setEndTime(Clock.getTime());
        historyTask.setState("obsolete");
        session.update((Object)historyTaskInstance);
    }

    @Override
    protected Class<? extends HistoryActivityInstanceImpl> getHistoryActivityInstanceClass() {
        return HistoryTaskInstanceImpl.class;
    }
}

