/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Continuation;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;
import org.jbpm.pvm.internal.model.op.ExecuteActivityMessage;
import org.jbpm.pvm.internal.util.Clock;

public class ExecuteActivity
extends AtomicOperation {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)ExecuteActivity.class.getName());

    public boolean isAsync(ExecutionImpl execution) {
        return execution.getActivity().isAsync();
    }

    public void perform(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (log.isDebugEnabled()) {
            if (execution.getName() != null) {
                log.debug(execution.toString() + " executes " + activity);
            } else {
                log.debug("executing " + activity);
            }
        }
        ActivityBehaviour activityBehaviour = activity.getActivityBehaviour();
        try {
            execution.setPropagation(ExecutionImpl.Propagation.UNSPECIFIED);
            execution.setHistoryActivityStart(Clock.getTime());
            activityBehaviour.execute((ActivityExecution)execution);
        }
        catch (Exception e) {
            execution.handleException(activity, null, null, e, execution.toString() + " couldn't execute " + activityBehaviour + " for activity " + activity);
        }
        if (execution.getPropagation() == ExecutionImpl.Propagation.UNSPECIFIED) {
            execution.proceed();
        }
    }

    public String toString() {
        return "ExecuteActivity";
    }

    public MessageImpl createAsyncMessage(ExecutionImpl execution) {
        ExecuteActivityMessage executeActivityMessage = new ExecuteActivityMessage(execution);
        if (execution.getActivity().getContinuation() == Continuation.EXCLUSIVE) {
            executeActivityMessage.setExclusive(true);
        }
        return executeActivityMessage;
    }
}

