/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.identity.Group;
import org.jbpm.api.task.Task;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskQueryImpl
extends AbstractQuery
implements TaskQuery {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)TaskQueryImpl.class.getName());
    protected boolean unassigned;
    protected String assignee;
    protected String candidate;
    protected Boolean suspended;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String activityName;
    protected List<String> groupIds;

    public TaskQuery assignee(String assignee) {
        if (this.candidate != null) {
            throw new JbpmException("assignee(...) cannot be combined with candidate(...) in one query");
        }
        this.assignee = assignee;
        return this;
    }

    public TaskQuery candidate(String userId) {
        this.candidate = userId;
        this.unassigned();
        return this;
    }

    public TaskQuery executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public TaskQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public TaskQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public TaskQuery activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    public TaskQuery unassigned() {
        this.assignee = null;
        this.unassigned = true;
        return this;
    }

    public TaskQuery suspended() {
        this.suspended = true;
        return this;
    }

    public TaskQuery notSuspended() {
        this.suspended = false;
        return this;
    }

    public TaskQuery orderAsc(String property) {
        this.orderByClause = "task." + property + " asc ";
        return this;
    }

    public TaskQuery orderDesc(String property) {
        this.orderByClause = "task." + property + " desc ";
        return this;
    }

    public TaskQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    @Override
    protected void applyParameters(Query query) {
        if (this.assignee != null) {
            log.debug("setting parameter assignee: " + this.assignee);
            query.setString("assignee", this.assignee);
        }
        if (this.candidate != null) {
            log.debug("setting parameter candidateUserId: " + this.candidate);
            query.setString("candidateUserId", this.candidate);
            if (this.groupIds != null) {
                log.debug("setting parameter candidateGroupIds: " + this.groupIds);
                query.setParameterList("candidateGroupIds", this.groupIds);
            }
        }
    }

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select ");
        if (this.candidate != null) {
            if (this.count) {
                hql.append("count(distinct task.id) ");
            } else {
                hql.append("distinct task.id ");
            }
            hql.append("from ");
            hql.append(ParticipationImpl.class.getName());
            hql.append(" as participant join participant.task as task ");
            this.appendWhereClause("participant.type = 'candidate' ", hql);
            IdentitySession identitySession = EnvironmentImpl.getFromCurrent(IdentitySession.class);
            List<Group> groups = identitySession.findGroupsByUser(this.candidate);
            if (groups.isEmpty()) {
                this.groupIds = null;
                this.appendWhereClause("participant.userId = :candidateUserId ", hql);
            } else {
                this.groupIds = new ArrayList<String>();
                for (Group group : groups) {
                    this.groupIds.add(group.getId());
                }
                this.appendWhereClause("(participant.userId = :candidateUserId or participant.groupId in (:candidateGroupIds))", hql);
            }
        } else {
            if (this.count) {
                hql.append("count(task) ");
            } else {
                hql.append("task ");
            }
            hql.append("from ");
            hql.append(TaskImpl.class.getName());
            hql.append(" as task ");
        }
        if (this.suspended != null) {
            if (this.suspended.booleanValue()) {
                this.appendWhereClause("task.state = 'suspended' ", hql);
            } else {
                this.appendWhereClause("task.state != 'suspended' ", hql);
            }
        }
        if (this.executionId != null) {
            this.appendWhereClause("task.execution.id = '" + this.executionId + "' ", hql);
        }
        if (this.processInstanceId != null) {
            this.appendWhereClause("task.processInstance.id = '" + this.processInstanceId + "' ", hql);
        }
        if (this.activityName != null) {
            this.appendWhereClause("task.execution.activityName = '" + this.activityName + "' ", hql);
        }
        if (this.processDefinitionId != null) {
            this.appendWhereClause("task.processInstance.processDefinitionId = '" + this.processDefinitionId + "' ", hql);
        }
        if (this.assignee != null) {
            this.appendWhereClause("task.assignee = :assignee ", hql);
        } else if (this.unassigned) {
            this.appendWhereClause("task.assignee is null ", hql);
        }
        if (this.candidate == null && !this.count) {
            this.appendOrderByClause(hql);
        }
        String hqlQuery = hql.toString();
        log.debug(hqlQuery);
        return hqlQuery;
    }

    @Override
    public Object execute(Session session) {
        Object result = super.execute(session);
        if (this.candidate == null || this.count) {
            return result;
        }
        if (this.uniqueResult) {
            if (result == null) {
                return null;
            }
            return session.get(TaskImpl.class, (Serializable)result);
        }
        List list = (List)result;
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        StringBuilder hql = new StringBuilder();
        hql.append("from ").append(TaskImpl.class.getName()).append(" as task ");
        this.isWhereAdded = false;
        this.appendWhereClause("task.id in (:identifiers) ", hql);
        this.appendOrderByClause(hql);
        return session.createQuery(hql.toString()).setParameterList("identifiers", (Collection)list).list();
    }

    public List<Task> list() {
        return CollectionUtil.checkList(this.untypedList(), Task.class);
    }

    public Task uniqueResult() {
        return (Task)this.untypedUniqueResult();
    }
}

