/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeWizard;
import org.antlr.test.BaseTest;

public class TestTreeWizard
extends BaseTest {
    protected static final String[] tokens = new String[]{"", "", "", "", "", "A", "B", "C", "D", "E", "ID", "VAR"};
    protected static final TreeAdaptor adaptor = new CommonTreeAdaptor();

    public void testSingleNode() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("ID");
        String string = commonTree.toStringTree();
        String string2 = "ID";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testSingleNodeWithArg() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("ID[foo]");
        String string = commonTree.toStringTree();
        String string2 = "foo";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testSingleNodeTree() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A)");
        String string = commonTree.toStringTree();
        String string2 = "A";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testSingleLevelTree() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C D)");
        String string = commonTree.toStringTree();
        String string2 = "(A B C D)";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testListTree() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(nil A B C)");
        String string = commonTree.toStringTree();
        String string2 = "A B C";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testInvalidListTree() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("A B C");
        TestTreeWizard.assertTrue((commonTree == null ? 1 : 0) != 0);
    }

    public void testDoubleLevelTree() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A (B C) (B D) E)");
        String string = commonTree.toStringTree();
        String string2 = "(A (B C) (B D) E)";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testSingleNodeIndex() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("ID");
        Map map = treeWizard.index(commonTree);
        String string = map.toString();
        String string2 = "{10=[ID]}";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testNoRepeatsIndex() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C D)");
        Map map = treeWizard.index(commonTree);
        String string = map.toString();
        String string2 = "{8=[D], 6=[B], 7=[C], 5=[A]}";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testRepeatsIndex() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B (A C B) B D D)");
        Map map = treeWizard.index(commonTree);
        String string = map.toString();
        String string2 = "{8=[D, D], 6=[B, B, B], 7=[C], 5=[A, A]}";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testNoRepeatsVisit() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C D)");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, treeWizard.getTokenType("B"), (TreeWizard.ContextVisitor)new TreeWizard.Visitor(){

            public void visit(Object object) {
                arrayList.add(object);
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[B]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testNoRepeatsVisit2() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B (A C B) B D D)");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, treeWizard.getTokenType("C"), (TreeWizard.ContextVisitor)new TreeWizard.Visitor(){

            public void visit(Object object) {
                arrayList.add(object);
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[C]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testRepeatsVisit() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B (A C B) B D D)");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, treeWizard.getTokenType("B"), (TreeWizard.ContextVisitor)new TreeWizard.Visitor(){

            public void visit(Object object) {
                arrayList.add(object);
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[B, B, B]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testRepeatsVisit2() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B (A C B) B D D)");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, treeWizard.getTokenType("A"), (TreeWizard.ContextVisitor)new TreeWizard.Visitor(){

            public void visit(Object object) {
                arrayList.add(object);
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[A, A]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testRepeatsVisitWithContext() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B (A C B) B D D)");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, treeWizard.getTokenType("B"), new TreeWizard.ContextVisitor(){

            public void visit(Object object, Object object2, int n, Map map) {
                arrayList.add(adaptor.getText(object) + "@" + (object2 != null ? adaptor.getText(object2) : "nil") + "[" + n + "]");
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[B@A[0], B@A[1], B@A[2]]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testRepeatsVisitWithNullParentAndContext() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B (A C B) B D D)");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, treeWizard.getTokenType("A"), new TreeWizard.ContextVisitor(){

            public void visit(Object object, Object object2, int n, Map map) {
                arrayList.add(adaptor.getText(object) + "@" + (object2 != null ? adaptor.getText(object2) : "nil") + "[" + n + "]");
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[A@nil[0], A@A[1]]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testVisitPattern() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C (A B) D)");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, "(A B)", (TreeWizard.ContextVisitor)new TreeWizard.Visitor(){

            public void visit(Object object) {
                arrayList.add(object);
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[A]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testVisitPatternMultiple() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C (A B) (D (A B)))");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, "(A B)", new TreeWizard.ContextVisitor(){

            public void visit(Object object, Object object2, int n, Map map) {
                arrayList.add(adaptor.getText(object) + "@" + (object2 != null ? adaptor.getText(object2) : "nil") + "[" + n + "]");
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[A@A[2], A@D[0]]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testVisitPatternMultipleWithLabels() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C (A[foo] B[bar]) (D (A[big] B[dog])))");
        final ArrayList arrayList = new ArrayList();
        treeWizard.visit((Object)commonTree, "(%a:A %b:B)", new TreeWizard.ContextVisitor(){

            public void visit(Object object, Object object2, int n, Map map) {
                arrayList.add(adaptor.getText(object) + "@" + (object2 != null ? adaptor.getText(object2) : "nil") + "[" + n + "]" + map.get("a") + "&" + map.get("b"));
            }
        });
        String string = ((Object)arrayList).toString();
        String string2 = "[foo@A[2]foo&bar, big@D[0]big&dog]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }

    public void testParse() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C)");
        boolean bl = treeWizard.parse(commonTree, "(A B C)");
        TestTreeWizard.assertTrue((boolean)bl);
    }

    public void testParseSingleNode() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("A");
        boolean bl = treeWizard.parse(commonTree, "A");
        TestTreeWizard.assertTrue((boolean)bl);
    }

    public void testParseFlatTree() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(nil A B C)");
        boolean bl = treeWizard.parse(commonTree, "(nil A B C)");
        TestTreeWizard.assertTrue((boolean)bl);
    }

    public void testWildcard() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C)");
        boolean bl = treeWizard.parse(commonTree, "(A . .)");
        TestTreeWizard.assertTrue((boolean)bl);
    }

    public void testParseWithText() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B[foo] C[bar])");
        boolean bl = treeWizard.parse(commonTree, "(A B[foo] C)");
        TestTreeWizard.assertTrue((boolean)bl);
    }

    public void testParseWithTextFails() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C)");
        boolean bl = treeWizard.parse(commonTree, "(A[foo] B C)");
        TestTreeWizard.assertTrue((!bl ? 1 : 0) != 0);
    }

    public void testParseLabels() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C)");
        HashMap hashMap = new HashMap();
        boolean bl = treeWizard.parse(commonTree, "(%a:A %b:B %c:C)", hashMap);
        TestTreeWizard.assertTrue((boolean)bl);
        TestTreeWizard.assertEquals((String)"A", (String)hashMap.get("a").toString());
        TestTreeWizard.assertEquals((String)"B", (String)hashMap.get("b").toString());
        TestTreeWizard.assertEquals((String)"C", (String)hashMap.get("c").toString());
    }

    public void testParseWithWildcardLabels() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C)");
        HashMap hashMap = new HashMap();
        boolean bl = treeWizard.parse(commonTree, "(A %b:. %c:.)", hashMap);
        TestTreeWizard.assertTrue((boolean)bl);
        TestTreeWizard.assertEquals((String)"B", (String)hashMap.get("b").toString());
        TestTreeWizard.assertEquals((String)"C", (String)hashMap.get("c").toString());
    }

    public void testParseLabelsAndTestText() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B[foo] C)");
        HashMap hashMap = new HashMap();
        boolean bl = treeWizard.parse(commonTree, "(%a:A %b:B[foo] %c:C)", hashMap);
        TestTreeWizard.assertTrue((boolean)bl);
        TestTreeWizard.assertEquals((String)"A", (String)hashMap.get("a").toString());
        TestTreeWizard.assertEquals((String)"foo", (String)hashMap.get("b").toString());
        TestTreeWizard.assertEquals((String)"C", (String)hashMap.get("c").toString());
    }

    public void testParseLabelsInNestedTree() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A (B C) (D E))");
        HashMap hashMap = new HashMap();
        boolean bl = treeWizard.parse(commonTree, "(%a:A (%b:B %c:C) (%d:D %e:E) )", hashMap);
        TestTreeWizard.assertTrue((boolean)bl);
        TestTreeWizard.assertEquals((String)"A", (String)hashMap.get("a").toString());
        TestTreeWizard.assertEquals((String)"B", (String)hashMap.get("b").toString());
        TestTreeWizard.assertEquals((String)"C", (String)hashMap.get("c").toString());
        TestTreeWizard.assertEquals((String)"D", (String)hashMap.get("d").toString());
        TestTreeWizard.assertEquals((String)"E", (String)hashMap.get("e").toString());
    }

    public void testEquals() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C)");
        CommonTree commonTree2 = (CommonTree)treeWizard.create("(A B C)");
        boolean bl = TreeWizard.equals(commonTree, commonTree2, adaptor);
        TestTreeWizard.assertTrue((boolean)bl);
    }

    public void testEqualsWithText() throws Exception {
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B[foo] C)");
        CommonTree commonTree2 = (CommonTree)treeWizard.create("(A B[foo] C)");
        boolean bl = TreeWizard.equals(commonTree, commonTree2, adaptor);
        TestTreeWizard.assertTrue((boolean)bl);
    }

    public void testEqualsWithMismatchedText() throws Exception {
        CommonTree commonTree;
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree2 = (CommonTree)treeWizard.create("(A B[foo] C)");
        boolean bl = TreeWizard.equals(commonTree2, commonTree = (CommonTree)treeWizard.create("(A B C)"), adaptor);
        TestTreeWizard.assertTrue((!bl ? 1 : 0) != 0);
    }

    public void testFindPattern() throws Exception {
        List list;
        TreeWizard treeWizard = new TreeWizard(adaptor, tokens);
        CommonTree commonTree = (CommonTree)treeWizard.create("(A B C (A[foo] B[bar]) (D (A[big] B[dog])))");
        List list2 = list = treeWizard.find((Object)commonTree, "(A B)");
        String string = list2.toString();
        String string2 = "[foo, big]";
        TestTreeWizard.assertEquals((String)string2, (String)string);
    }
}

