/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import org.mule.api.MuleContext;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;

public abstract class AbstractJob
implements Job {
    protected MuleContext muleContext;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.muleContext = this.getMuleContext(jobExecutionContext);
        if (this.muleContext.isPrimaryPollingInstance() || jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"jobDynamic") == Boolean.TRUE) {
            this.doExecute(jobExecutionContext);
        }
    }

    protected abstract void doExecute(JobExecutionContext var1) throws JobExecutionException;

    protected MuleContext getMuleContext(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            SchedulerContext schedulerContext = jobExecutionContext.getScheduler().getContext();
            return (MuleContext)schedulerContext.get((Object)"mule.context");
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Failed to retrieve MuleContext from the Scheduler Context: " + e.getMessage(), (Throwable)e);
        }
    }
}

