/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.transport.NullPayload;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.AbstractJob;
import org.mule.transport.quartz.jobs.ScheduledDispatchJobConfig;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class ScheduledDispatchJob
extends AbstractJob
implements Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    protected void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        ScheduledDispatchJobConfig config;
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Object payload = jobDataMap.get((Object)"payload");
        if (payload == null) {
            payload = NullPayload.getInstance();
        }
        if ((config = (ScheduledDispatchJobConfig)jobDataMap.get((Object)"jobConfig")) == null) {
            throw new JobExecutionException(QuartzMessages.missingJobDetail("jobConfig").getMessage());
        }
        if (this instanceof StatefulJob) {
            jobDataMap.put((Object)"MULE_FORCE_SYNC", (Object)Boolean.TRUE);
        }
        try {
            String endpointRef = config.getEndpointRef();
            if (jobDataMap.containsKey((Object)"endpointRef")) {
                endpointRef = (String)jobDataMap.get((Object)"endpointRef");
            }
            this.logger.debug((Object)("Dispatching payload on: " + config.getEndpointRef()));
            this.dispatch(endpointRef, payload, jobDataMap);
        }
        catch (MuleException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    protected void dispatch(String endpointRef, Object payload, JobDataMap jobDataMap) throws MuleException {
        JobDataMap properties = jobDataMap;
        DefaultMuleMessage message = new DefaultMuleMessage(payload, (Map)properties, this.muleContext);
        DefaultLocalMuleClient.MuleClientFlowConstruct flowConstruct = new DefaultLocalMuleClient.MuleClientFlowConstruct(this.muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)flowConstruct);
        OutboundEndpoint endpoint = this.getOutboundEndpoint(endpointRef);
        endpoint.process((MuleEvent)event);
    }

    protected OutboundEndpoint getOutboundEndpoint(String uri) throws MuleException {
        EndpointFactory factory = this.muleContext.getEndpointFactory();
        EndpointBuilder endpointBuilder = factory.getEndpointBuilder(uri);
        endpointBuilder.setExchangePattern(MessageExchangePattern.ONE_WAY);
        return factory.getOutboundEndpoint(endpointBuilder);
    }
}

