/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jibx.tools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jibx.tools.JibxSchemaHelper;
import org.apache.cxf.jibx.tools.JibxSchemaResolver;
import org.apache.cxf.jibx.tools.JibxToolingProblemHandler;
import org.apache.cxf.tools.common.ClassUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.DefaultValueWriter;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.jibx.binding.Compile;
import org.jibx.binding.Utility;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.BindingOrganizer;
import org.jibx.binding.model.BindingUtils;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.ModelVisitor;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.TreeContext;
import org.jibx.binding.model.ValueElement;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.schema.codegen.CodeGen;
import org.jibx.schema.codegen.PackageHolder;
import org.jibx.schema.codegen.PackageOrganizer;
import org.jibx.schema.codegen.StringObjectPair;
import org.jibx.schema.codegen.custom.SchemaCustom;
import org.jibx.schema.codegen.custom.SchemasetCustom;
import org.jibx.schema.validation.ProblemHandler;
import org.jibx.schema.validation.ProblemMultiHandler;
import org.jibx.util.DummyClassLocator;
import org.jibx.util.IClassLocator;
import org.jibx.util.LazyList;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JibxToolingDataBinding
implements DataBindingProfile {
    private JibxToolingProblemHandler problemHandler = new JibxToolingProblemHandler();
    private Map<String, Element> schemaMap = new HashMap<String, Element>();
    private List<JibxSchemaResolver> resolvers = new ArrayList<JibxSchemaResolver>();
    private Map<QName, MappingElement> types = new HashMap<QName, MappingElement>();
    private Map<QName, MappingElement> elements = new HashMap<QName, MappingElement>();

    public DefaultValueWriter createDefaultValueWriter(javax.xml.namespace.QName qn, boolean element) {
        return null;
    }

    public DefaultValueWriter createDefaultValueWriterForWrappedElement(javax.xml.namespace.QName wrapperElement, javax.xml.namespace.QName qn) {
        return null;
    }

    public void generate(ToolContext context) throws ToolException {
        try {
            File compilePath;
            File generatePath;
            JiBXCodeGen codegen = new JiBXCodeGen();
            ProblemMultiHandler handler = new ProblemMultiHandler();
            handler.addHandler((ProblemHandler)this.problemHandler);
            codegen.setProblemHandler(handler);
            String sourcePath = (String)context.get("outputdir");
            if (sourcePath == null) {
                sourcePath = new File(".").getAbsolutePath();
            }
            if (!(generatePath = new File(sourcePath)).exists()) {
                generatePath.mkdir();
            }
            codegen.setGeneratePath(generatePath);
            String wsdlUrl = URIParserUtil.getAbsoluteURI((String)((String)context.get("wsdlurl")));
            if (wsdlUrl.contains("/")) {
                wsdlUrl = wsdlUrl.substring(wsdlUrl.lastIndexOf(47));
            }
            if (wsdlUrl.toLowerCase().endsWith(".wsdl")) {
                wsdlUrl = wsdlUrl.substring(0, wsdlUrl.length() - 5);
            }
            wsdlUrl = wsdlUrl + ".xml";
            File jibxDir = new File(generatePath, "jibx_bindings/");
            jibxDir.mkdirs();
            codegen.setBindingName("jibx_bindings/" + wsdlUrl);
            String classPath = (String)context.get("classdir");
            if (classPath == null) {
                classPath = new File(".").getAbsolutePath();
            }
            if (!(compilePath = new File(classPath)).exists()) {
                compilePath.mkdir();
            }
            codegen.setCompilePath(compilePath);
            codegen.setFileset(this.resolvers);
            String[] bindingFiles = (String[])context.get("binding");
            SchemasetCustom customRoot = bindingFiles == null || bindingFiles.length == 0 ? this.defaultSchemasetCustom(this.schemaMap) : SchemasetCustom.loadCustomizations((String)bindingFiles[0], (ProblemHandler)handler);
            JibxToolingDataBinding.forceTypes(customRoot);
            codegen.setCustomRoot(customRoot);
            codegen.generate();
            if (Boolean.valueOf((String)context.get("compile")).booleanValue()) {
                if (context.get("sourcedir") == null) {
                    context.put("sourcedir", (Object)generatePath.getAbsolutePath());
                }
                if (context.get("classdir") == null) {
                    context.put("classdir", (Object)compilePath.getAbsolutePath());
                }
                ClassCollector collector = new ClassCollector();
                JibxToolingDataBinding.addGeneratedSourceFiles(codegen.getPackageOrganizer(), collector);
                context.put(ClassCollector.class, (Object)collector);
                new ClassUtils().compile(context);
                codegen.compile();
            }
            HashMap formats = new HashMap();
            BindingUtils.getDefinitions((BindingElement)codegen.getRootBinding(), this.types, this.elements, formats);
            Iterator it = codegen.getBindingOrganizer().iterateBindings();
            while (it.hasNext()) {
                BindingHolder o = (BindingHolder)it.next();
                if (o == null) continue;
                JibxToolingDataBinding.getDefinitions(o, this.types, this.elements);
            }
        }
        catch (Exception e) {
            this.problemHandler.handleSevere("", e);
        }
    }

    public static void getDefinitions(final BindingHolder holder, final Map<QName, MappingElement> types, final Map<QName, MappingElement> elems) {
        TreeContext ctx = new TreeContext((IClassLocator)new DummyClassLocator());
        ModelVisitor visitor = new ModelVisitor(){

            public boolean visit(MappingElement mapping) {
                String name;
                QName qname = mapping.getTypeQName();
                if (qname != null) {
                    types.put(qname, mapping);
                }
                if ((name = mapping.getName()) != null) {
                    NamespaceElement ns = mapping.getNamespace();
                    qname = ns == null ? new QName(holder.getElementDefaultNamespace(), name) : new QName(mapping.getNamespace().getUri(), name);
                    elems.put(qname, mapping);
                }
                return false;
            }
        };
        ctx.tourTree(holder.getBinding(), visitor);
    }

    public String getType(javax.xml.namespace.QName qn, boolean element) {
        MappingElement mappingElement = element ? this.elements.get(JibxToolingDataBinding.jibxQName(qn)) : this.types.get(JibxToolingDataBinding.jibxQName(qn));
        return mappingElement == null ? null : mappingElement.getClassName();
    }

    public String getWrappedElementType(javax.xml.namespace.QName wrapperElement, javax.xml.namespace.QName item) {
        MappingElement mappingElement = this.elements.get(JibxToolingDataBinding.jibxQName(wrapperElement));
        return mappingElement == null ? null : JibxToolingDataBinding.itemType(mappingElement, item);
    }

    public void initialize(ToolContext context) throws ToolException {
        context.put("databinding-class", (Object)"org.apache.cxf.jibx.JibxDataBinding.class");
        String wsdlUrl = (String)context.get("wsdlurl");
        this.initializeJiBXCodeGenerator(wsdlUrl);
    }

    private void initializeJiBXCodeGenerator(String wsdlUrl) {
        try {
            JibxToolingDataBinding.loadWsdl(wsdlUrl, this.schemaMap, this.resolvers);
        }
        catch (WSDLException e) {
            this.problemHandler.handleSevere("Error in loading wsdl file at :" + wsdlUrl, e);
        }
    }

    private static void loadWsdl(String wsdlUrl, Map<String, Element> schemaMap, List<JibxSchemaResolver> resolvers) throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        Definition parentDef = reader.readWSDL(wsdlUrl);
        JibxSchemaHelper util = new JibxSchemaHelper(BusFactory.getDefaultBus(), schemaMap);
        util.getSchemas(parentDef, new SchemaCollection(), resolvers);
    }

    private static QName jibxQName(javax.xml.namespace.QName qname) {
        return new QName(qname.getNamespaceURI(), qname.getLocalPart());
    }

    private static String itemType(MappingElement mappingElement, javax.xml.namespace.QName qName) {
        String localPart = qName.getLocalPart();
        Iterator childIterator = mappingElement.childIterator();
        while (childIterator.hasNext()) {
            ValueElement valueElement;
            Object child = childIterator.next();
            if (!(child instanceof ValueElement) || !localPart.equals((valueElement = (ValueElement)child).getName())) continue;
            return valueElement.getDeclaredType();
        }
        return null;
    }

    private SchemasetCustom defaultSchemasetCustom(Map<String, Element> smap) {
        SchemaCustom schemaCustom;
        SchemasetCustom customRoot = new SchemasetCustom((SchemasetCustom)null);
        Set<String> schemaIds = smap.keySet();
        for (String schemaId : schemaIds) {
            schemaCustom = new SchemaCustom(customRoot);
            schemaCustom.setName(schemaId);
            schemaCustom.setForceTypes(Boolean.TRUE);
            schemaCustom.setNamespace(smap.get(schemaId).getAttribute("targetNamespace"));
            customRoot.getChildren().add((Object)schemaCustom);
        }
        for (JibxSchemaResolver r : this.resolvers) {
            if (schemaIds.contains(r.getId())) continue;
            schemaCustom = new SchemaCustom(customRoot);
            schemaCustom.setName(r.getName());
            schemaCustom.setNamespace(r.getElement().getAttribute("targetNamespace"));
            schemaCustom.setForceTypes(Boolean.TRUE);
            customRoot.getChildren().add((Object)schemaCustom);
        }
        return customRoot;
    }

    private static void forceTypes(SchemasetCustom customRoot) {
        LazyList children = customRoot.getChildren();
        for (Object child : children) {
            SchemaCustom schemaCustom = (SchemaCustom)child;
            schemaCustom.setForceTypes(Boolean.TRUE);
        }
    }

    private static void addGeneratedSourceFiles(PackageOrganizer o, ClassCollector collector) {
        List packages = CastUtils.cast((List)o.getPackages());
        for (PackageHolder pkgHolder : packages) {
            if (pkgHolder.getTopClassCount() <= 0) continue;
            String pkgName = pkgHolder.getName();
            StringObjectPair[] classFields = pkgHolder.getClassFields();
            for (int i = 0; i < classFields.length; ++i) {
                String fullname = classFields[i].getKey();
                if (fullname.contains("$")) continue;
                collector.addTypesClassName(pkgName, fullname.replace(pkgName, ""), fullname);
            }
        }
    }

    static class JiBXCodeGen {
        private ProblemMultiHandler problemHandler;
        private SchemasetCustom customRoot;
        private URL schemaRoot;
        private File generatePath;
        private boolean verbose;
        private String usingNamespace;
        private String nonamespacePackage;
        private String bindingName = "binding";
        private List fileset;
        private List includePaths = new ArrayList();
        private File modelFile;
        private BindingElement rootBinding;
        private File compilePath;
        private PackageOrganizer packageOrganizer;
        private BindingOrganizer bindingOrganizer;

        JiBXCodeGen() {
        }

        public void setProblemHandler(ProblemMultiHandler problemHandler) {
            this.problemHandler = problemHandler;
        }

        public BindingOrganizer getBindingOrganizer() {
            return this.bindingOrganizer;
        }

        public void setCustomRoot(SchemasetCustom customRoot) {
            this.customRoot = customRoot;
        }

        public void setSchemaRoot(URL schemaRoot) {
            this.schemaRoot = schemaRoot;
        }

        public void setGeneratePath(File generatePath) {
            this.generatePath = generatePath;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public void setUsingNamespace(String usingNamespace) {
            this.usingNamespace = usingNamespace;
        }

        public void setNonamespacePackage(String nonamespacePackage) {
            this.nonamespacePackage = nonamespacePackage;
        }

        public void setBindingName(String bindingName) {
            this.bindingName = bindingName;
        }

        public List getFileset() {
            return this.fileset;
        }

        public void setFileset(List fileset) {
            this.fileset = fileset;
        }

        public void setIncludePaths(List includePaths) {
            this.includePaths = includePaths;
        }

        public void setModelFile(File modelFile) {
            this.modelFile = modelFile;
        }

        public BindingElement getRootBinding() {
            return this.rootBinding;
        }

        public PackageOrganizer getPackageOrganizer() {
            return this.packageOrganizer;
        }

        public void setCompilePath(File compilePath) {
            this.compilePath = compilePath;
        }

        public void generate() throws JiBXException, IOException {
            CodeGen codegen = new CodeGen(this.customRoot, this.schemaRoot, this.generatePath);
            codegen.generate(this.verbose, this.usingNamespace, this.nonamespacePackage, this.bindingName, this.fileset, this.includePaths, this.modelFile, (ProblemHandler)this.problemHandler);
            this.setPostGenerateInfo(codegen);
        }

        public void compile() throws JiBXException {
            Compile compiler = new Compile();
            String path = this.generatePath.getAbsolutePath();
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            ArrayList<String> clsPath = new ArrayList<String>();
            clsPath.add(this.compilePath.getAbsolutePath());
            clsPath.addAll(Arrays.asList(Utility.getClassPaths()));
            String[] clsPathSet = clsPath.toArray(new String[clsPath.size()]);
            String[] bindingSet = new String[]{path + this.bindingName + ".xml"};
            compiler.compile(clsPathSet, bindingSet);
        }

        private void setPostGenerateInfo(CodeGen codegen) {
            this.bindingOrganizer = codegen.getBindingDirectory();
            this.rootBinding = codegen.getRootBinding();
            this.packageOrganizer = codegen.getPackageDirectory();
        }
    }
}

