/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.ConnectionFactory;
import org.mule.api.MuleContext;
import org.mule.transport.jms.AbstractConnectionFactoryDecorator;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.xa.ConnectionFactoryWrapper;

public class DefaultConnectionFactoryDecorator
extends AbstractConnectionFactoryDecorator {
    @Override
    protected ConnectionFactory doDecorate(ConnectionFactory connectionFactory, JmsConnector jmsConnector, MuleContext muleContext) {
        ConnectionFactory wrappedConnectionFactory = connectionFactory;
        if (this.isXaConnectionFactory(connectionFactory) && muleContext.getTransactionManager() != null) {
            wrappedConnectionFactory = new ConnectionFactoryWrapper(connectionFactory, jmsConnector.getSameRMOverrideValue());
        }
        return wrappedConnectionFactory;
    }

    @Override
    public boolean appliesTo(ConnectionFactory connectionFactory, MuleContext muleContext) {
        return !this.isConnectionFactoryWrapper(connectionFactory) && this.isConnectionFactoryXaAndThereIsATxManager(connectionFactory, muleContext);
    }

    private boolean isConnectionFactoryXaAndThereIsATxManager(ConnectionFactory connectionFactory, MuleContext muleContext) {
        return this.isXaConnectionFactory(connectionFactory) && muleContext.getTransactionFactoryManager() != null;
    }
}

