/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.MessageFactory;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.processor.FetchAccessTokenMessageProcessor;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2FetchAccessTokenMessageProcessor
extends FetchAccessTokenMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2FetchAccessTokenMessageProcessor.class);
    private static final Pattern EVENT_ID_PATTERN = Pattern.compile("<<MULE_EVENT_ID=([\\w-]*)>>");
    private static final Pattern ORIGINAL_STATE_PATTERN = Pattern.compile("<<MULE_EVENT_ID=[\\w-]*>>(.*)");
    private OAuth2Manager<OAuth2Adapter> oauthManager;

    public OAuth2FetchAccessTokenMessageProcessor(OAuth2Manager<OAuth2Adapter> oauthManager, String accessTokenId) {
        this.oauthManager = oauthManager;
        this.setAccessTokenId(accessTokenId);
    }

    @Override
    protected MuleEvent doProcess(MuleEvent event) throws Exception {
        MuleEvent restoredEvent = this.restoreOriginalEvent(event);
        this.notifyCallbackReception(event);
        try {
            OAuth2Adapter oauthAdapter = this.oauthManager.createAdapter((String)event.getMessage().getInvocationProperty("_oauthVerifier"));
            if (oauthAdapter.getAccessTokenUrl() == null) {
                oauthAdapter.setAccessTokenUrl(this.getAccessTokenUrl());
            }
            oauthAdapter.fetchAccessToken(this.getRedirectUri());
            String transformedAccessTokenId = this.getAccessTokenId();
            if (StringUtils.isEmpty((String)transformedAccessTokenId)) {
                transformedAccessTokenId = this.oauthManager.getDefaultUnauthorizedConnector().getName();
            }
            transformedAccessTokenId = (String)this.evaluateAndTransform(restoredEvent.getMuleContext(), restoredEvent, (Type)((Object)String.class), null, (Object)transformedAccessTokenId);
            this.oauthManager.getAccessTokenPoolFactory().passivateObject((Object)transformedAccessTokenId, (Object)oauthAdapter);
            MuleMessage message = restoredEvent.getMessage();
            message.setInvocationProperty("_oauthVerifier", event.getMessage().getInvocationProperty("_oauthVerifier"));
            message.setInvocationProperty("OAuthAccessTokenId", (Object)transformedAccessTokenId);
            message.removeProperty("http.status", PropertyScope.OUTBOUND);
            message.removeProperty("Location", PropertyScope.OUTBOUND);
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)"Unable to fetch access token"), event, (Throwable)e);
        }
        return restoredEvent;
    }

    private MuleEvent restoreOriginalEvent(MuleEvent event) throws MuleException {
        String state = (String)event.getMessage().getInboundProperty("state");
        if (StringUtils.isEmpty((String)state)) {
            return event;
        }
        try {
            state = URLDecoder.decode(state, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)("State query param had invalid encoding: " + state)), event);
        }
        String eventId = StringUtils.match((Pattern)EVENT_ID_PATTERN, (String)state, (int)1);
        if (StringUtils.isBlank((String)eventId)) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("Could not fetch original event id for callback with state %s. Will continue with new event without restoring previous one", state));
            }
            return event;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("received callback for event id %s. Fetching original event", eventId));
        }
        MuleEvent restoredEvent = null;
        try {
            restoredEvent = this.oauthManager.restoreAuthorizationEvent(eventId);
        }
        catch (ObjectDoesNotExistException e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)String.format("Could not find authorization event %s in object store", eventId)), event, (Throwable)e);
        }
        catch (ObjectStoreException e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)String.format("Error retrieving authorization event %s from object store", eventId)), event, (Throwable)e);
        }
        MuleMessage restoredMessage = restoredEvent.getMessage();
        String cleanedState = StringUtils.match((Pattern)ORIGINAL_STATE_PATTERN, (String)state, (int)1);
        if (cleanedState != null) {
            restoredMessage.setProperty("state", (Object)cleanedState, PropertyScope.INBOUND);
        } else {
            restoredMessage.setProperty("state", (Object)"", PropertyScope.INBOUND);
        }
        RequestContext.setEvent((MuleEvent)restoredEvent);
        return restoredEvent;
    }
}

