/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.TestNotSerializableMessageProcessor;
import org.mule.api.TestSerializableMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class MessagingExceptionTestCase
extends AbstractMuleContextTestCase {
    private static final String message = "a message";
    private static final String value = "Hello world!";
    @Mock
    private MuleEvent mockEvent;

    @Test
    public void testGetCauseExceptionWithoutCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)((Object)((MessagingException)((Object)exception.getCauseException()))), (Matcher)Is.is((Object)((Object)exception)));
    }

    @Test
    public void testGetCauseExceptionWithMuleCause() {
        DefaultMuleException causeException = new DefaultMuleException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((DefaultMuleException)exception.getCauseException()), (Matcher)Is.is((Object)causeException));
    }

    @Test
    public void testGetCauseExceptionWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((DefaultMuleException)exception.getCauseException()), (Matcher)Is.is((Object)causeCauseException));
    }

    @Test
    public void testGetCauseExceptionWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((IOException)exception.getCauseException()), (Matcher)Is.is((Object)causeException));
    }

    @Test
    public void testGetCauseExceptionWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((ConnectException)exception.getCauseException()), (Matcher)Is.is((Object)causeCauseException));
    }

    @Test
    public void testCausedByWithNullCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(Exception.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(DefaultMuleException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCausedByWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(DefaultMuleException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testCausedByWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(Exception.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(NullPointerException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCausedByWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(NullPointerException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedBy(SocketException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testCausedExactlyByWithNullCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(Exception.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(DefaultMuleException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCausedExactlyByWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(DefaultMuleException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testCausedExactlyByWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(Exception.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(NullPointerException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCausedExactlyByWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(ConnectException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(SocketException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testSerializableMessagingException() throws Exception {
        TestSerializableMessageProcessor processor = new TestSerializableMessageProcessor();
        processor.setValue(value);
        MessagingException e = new MessagingException(MessageFactory.createStaticMessage((String)message), MessagingExceptionTestCase.getTestEvent(""), (MessageProcessor)processor);
        e = SerializationTestUtils.testException(e, muleContext);
        junit.framework.Assert.assertTrue((boolean)e.getMessage().contains(message));
        junit.framework.Assert.assertNotNull((Object)e.getFailingMessageProcessor());
        junit.framework.Assert.assertTrue((boolean)(e.getFailingMessageProcessor() instanceof TestSerializableMessageProcessor));
        junit.framework.Assert.assertEquals((String)value, (String)((TestSerializableMessageProcessor)e.getFailingMessageProcessor()).getValue());
    }

    @Test
    public void testNonSerializableMessagingException() throws Exception {
        TestNotSerializableMessageProcessor processor = new TestNotSerializableMessageProcessor();
        MessagingException e = new MessagingException(MessageFactory.createStaticMessage((String)message), MessagingExceptionTestCase.getTestEvent(""), (MessageProcessor)processor);
        e = SerializationTestUtils.testException(e, muleContext);
        junit.framework.Assert.assertTrue((boolean)e.getMessage().contains(message));
        junit.framework.Assert.assertNull((Object)e.getFailingMessageProcessor());
    }
}

