/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.pool;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.config.ThreadingProfile;
import org.mule.config.pool.DefaultThreadPoolFactory;
import org.mule.config.pool.ThreadPoolFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class DefaultThreadPoolFactoryTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void defaultThreadPoolFactory() throws Exception {
        ThreadingProfile tp = muleContext.getDefaultThreadingProfile();
        ThreadPoolFactory pf = tp.getPoolFactory();
        Assert.assertThat((Object)pf, (Matcher)IsInstanceOf.instanceOf(DefaultThreadPoolFactory.class));
    }

    @Test
    public void scheduledThreadPollDefaults() throws Exception {
        ThreadingProfile threadingProfile = muleContext.getDefaultThreadingProfile();
        ScheduledExecutorService executorService = threadingProfile.createScheduledPool("sapo pepe");
        Assert.assertThat((Object)executorService, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)executorService, (Matcher)IsInstanceOf.instanceOf(ScheduledThreadPoolExecutor.class));
        ScheduledThreadPoolExecutor scheduledPool = (ScheduledThreadPoolExecutor)executorService;
        Assert.assertThat((Object)scheduledPool.getContinueExistingPeriodicTasksAfterShutdownPolicy(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)scheduledPool.getExecuteExistingDelayedTasksAfterShutdownPolicy(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)scheduledPool.getMaximumPoolSize(), (Matcher)Is.is((Object)threadingProfile.getMaxThreadsActive()));
        Assert.assertThat((Object)scheduledPool.getCorePoolSize(), (Matcher)Is.is((Object)threadingProfile.getMaxThreadsIdle()));
        Assert.assertThat((Object)scheduledPool.getKeepAliveTime(TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)threadingProfile.getThreadTTL()));
    }

    @Test
    public void scheduledThreadPollRejectHandler() throws Exception {
        ThreadingProfile threadingProfile = muleContext.getDefaultThreadingProfile();
        ThreadPoolExecutor.DiscardOldestPolicy expectedRejectedExecutionHandler = new ThreadPoolExecutor.DiscardOldestPolicy();
        threadingProfile.setRejectedExecutionHandler((RejectedExecutionHandler)expectedRejectedExecutionHandler);
        ScheduledExecutorService executorService = threadingProfile.createScheduledPool("sapo pepe");
        ScheduledThreadPoolExecutor scheduledPool = (ScheduledThreadPoolExecutor)executorService;
        Assert.assertThat((Object)scheduledPool.getRejectedExecutionHandler(), (Matcher)Is.is((Object)expectedRejectedExecutionHandler));
    }
}

