/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ListMessageSplitter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;

public class FilterListMessageSplitterRouterTestCase
extends AbstractMuleContextTestCase {
    private MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
    private List<Object> payload;

    public FilterListMessageSplitterRouterTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.payload = new ArrayList<Object>();
        this.payload.add(new Apple());
        this.payload.add(new Apple());
        this.payload.add(new Orange());
        this.payload.add(new String());
    }

    @Test
    public void testMessageSplitterRouterOneWay() throws Exception {
        OutboundEndpoint endpoint1 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        OutboundEndpoint endpoint3 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        OutboundEndpoint mockendpoint3 = RouterTestUtils.createMockEndpoint(endpoint3);
        ListMessageSplitter router = this.createObject(ListMessageSplitter.class);
        router.setFilter((Filter)new PayloadTypeFilter(List.class));
        router.addRoute((MessageProcessor)mockendpoint1);
        router.addRoute((MessageProcessor)mockendpoint2);
        router.addRoute((MessageProcessor)mockendpoint3);
        DefaultMuleMessage message = new DefaultMuleMessage(this.payload, muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        Mockito.when((Object)mockendpoint3.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
    }

    @Test
    public void testMessageSplitterRouterRequestResponse() throws Exception {
        OutboundEndpoint endpoint1 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1?exchangePattern=request-response", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2?exchangePattern=request-response", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        OutboundEndpoint endpoint3 = FilterListMessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3?exchangePattern=request-response");
        OutboundEndpoint mockendpoint3 = RouterTestUtils.createMockEndpoint(endpoint3);
        ListMessageSplitter router = this.createObject(ListMessageSplitter.class);
        router.setFilter((Filter)new PayloadTypeFilter(List.class));
        router.addRoute((MessageProcessor)mockendpoint1);
        router.addRoute((MessageProcessor)mockendpoint2);
        router.addRoute((MessageProcessor)mockendpoint3);
        DefaultMuleMessage message = new DefaultMuleMessage(this.payload, muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mockendpoint3.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage.getPayload() instanceof List));
        Assert.assertEquals((long)((List)resultMessage.getPayload()).size(), (long)4L);
    }
}

