/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.util.Random;
import javax.transaction.TransactionManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transaction.XaTransaction;
import org.mule.util.xa.XaResourceFactoryHolder;

@RunWith(value=MockitoJUnitRunner.class)
public class XaTransactionTestCase
extends AbstractMuleTestCase {
    @Mock
    private MuleContext mockMuleContext;
    @Mock
    private TransactionManager mockTransactionManager;
    @Mock
    private XaResourceFactoryHolder mockXaResourceFactoryHolder1;
    @Mock
    private XaResourceFactoryHolder mockXaResourceFactoryHolder2;

    @Before
    public void setUpMuleContext() {
        Mockito.when((Object)this.mockMuleContext.getTransactionManager()).thenReturn((Object)this.mockTransactionManager);
    }

    @Test
    public void overcomeBadHashCodeImplementations() throws Exception {
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        BadHashCodeImplementation badHashCodeImplementation = new BadHashCodeImplementation();
        Object resource = new Object();
        xaTransaction.bindResource((Object)badHashCodeImplementation, resource);
        Assert.assertThat((Object)xaTransaction.hasResource((Object)badHashCodeImplementation), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)xaTransaction.getResource((Object)badHashCodeImplementation), (Matcher)Is.is((Object)resource));
    }

    @Test
    public void recognizeDifferentWrappersOfSameResource() throws Exception {
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        Object resourceFactory = new Object();
        Object resource = new Object();
        Mockito.when((Object)this.mockXaResourceFactoryHolder1.getHoldObject()).thenReturn(resourceFactory);
        Mockito.when((Object)this.mockXaResourceFactoryHolder2.getHoldObject()).thenReturn(resourceFactory);
        xaTransaction.bindResource((Object)this.mockXaResourceFactoryHolder1, resource);
        Assert.assertThat((Object)xaTransaction.hasResource((Object)this.mockXaResourceFactoryHolder1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)xaTransaction.hasResource((Object)this.mockXaResourceFactoryHolder2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)xaTransaction.getResource((Object)this.mockXaResourceFactoryHolder2), (Matcher)Is.is((Object)resource));
    }

    private class BadHashCodeImplementation {
        private BadHashCodeImplementation() {
        }

        public int hashCode() {
            return new Random(System.nanoTime()).nextInt();
        }
    }
}

