/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.compression;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.compression.GZipCompressTransformer;
import org.mule.transformer.compression.GZipUncompressTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.compression.GZipCompression;

public class GZipTransformerTestCase
extends AbstractTransformerTestCase {
    protected static final String TEST_DATA = "the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog";
    protected GZipCompression strat;

    @Override
    protected void doSetUp() throws Exception {
        this.strat = new GZipCompression();
    }

    @Override
    public Object getResultData() {
        try {
            return this.strat.compressByteArray(TEST_DATA.getBytes());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    @Override
    public Object getTestData() {
        return TEST_DATA;
    }

    @Override
    public Transformer getTransformer() {
        return new GZipCompressTransformer();
    }

    @Override
    public Transformer getRoundTripTransformer() {
        GZipUncompressTransformer transformer = new GZipUncompressTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnDataType(DataTypeFactory.STRING);
        try {
            transformer.initialise();
        }
        catch (InitialisationException e) {
            Assert.fail((String)e.getMessage());
        }
        return transformer;
    }

    @Test
    public void testCompressAndDecompress() throws Exception {
        Transformer compressorTransformer = this.getTransformer();
        Transformer decompressorTransformer = this.getRoundTripTransformer();
        Object compressedData = compressorTransformer.transform(this.getTestData());
        Object decompressedData = decompressorTransformer.transform(compressedData);
        Assert.assertTrue((String)String.format("Compress and decompress process failed. Expected '%s', but got '%s'", this.getTestData(), decompressedData), (boolean)this.compareResults(this.getTestData(), decompressedData));
    }
}

