/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.store.MuleObjectStoreManager;
import org.mule.util.store.ObjectStorePartition;

@SmallTest
public class MuleObjectStoreManagerTestCase
extends AbstractMuleTestCase {
    private MuleObjectStoreManager storeManager = new MuleObjectStoreManager();

    @Test
    public void disposeDisposableStore() throws ObjectStoreException {
        ObjectStore store = (ObjectStore)Mockito.mock(ObjectStore.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Disposable.class}));
        this.storeManager.disposeStore(store);
        ((ObjectStore)Mockito.verify((Object)store)).clear();
        ((Disposable)Mockito.verify((Object)((Disposable)store))).dispose();
    }

    @Test
    public void disposePartitionableStore() throws ObjectStoreException {
        String partitionName = "partition";
        ObjectStorePartition store = (ObjectStorePartition)Mockito.mock(ObjectStorePartition.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Disposable.class}).defaultAnswer(Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)store.getPartitionName()).thenReturn((Object)partitionName);
        this.storeManager.disposeStore((ObjectStore)store);
        ((PartitionableObjectStore)Mockito.verify((Object)store.getBaseStore())).disposePartition(partitionName);
        ((ObjectStorePartition)Mockito.verify((Object)store, (VerificationMode)Mockito.never())).clear();
        ((Disposable)Mockito.verify((Object)((Disposable)store))).dispose();
    }

    @Test
    public void dontFailIfUnsupported() throws ObjectStoreException {
        ObjectStore store = (ObjectStore)Mockito.mock(ObjectStore.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Disposable.class}));
        ((ObjectStore)Mockito.doThrow(UnsupportedOperationException.class).when((Object)store)).clear();
        this.storeManager.disposeStore(store);
        ((ObjectStore)Mockito.verify((Object)store)).clear();
        ((Disposable)Mockito.verify((Object)((Disposable)store))).dispose();
    }
}

