/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Date;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class SimpleTrigger
extends Trigger {
    private static final long serialVersionUID = -3735980074222850397L;
    public static final int MISFIRE_INSTRUCTION_FIRE_NOW = 1;
    public static final int MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT = 2;
    public static final int MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT = 3;
    public static final int MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT = 4;
    public static final int MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT = 5;
    public static final int REPEAT_INDEFINITELY = -1;
    private static final int YEAR_TO_GIVEUP_SCHEDULING_AT = 2299;
    private Date startTime = null;
    private Date endTime = null;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private int repeatCount = 0;
    private long repeatInterval = 0L;
    private int timesTriggered = 0;
    private boolean complete = false;

    public SimpleTrigger() {
    }

    public SimpleTrigger(String name) {
        this(name, (String)null);
    }

    public SimpleTrigger(String name, String group) {
        this(name, group, new Date(), null, 0, 0L);
    }

    public SimpleTrigger(String name, int repeatCount, long repeatInterval) {
        this(name, null, repeatCount, repeatInterval);
    }

    public SimpleTrigger(String name, String group, int repeatCount, long repeatInterval) {
        this(name, group, new Date(), null, repeatCount, repeatInterval);
    }

    public SimpleTrigger(String name, Date startTime) {
        this(name, null, startTime);
    }

    public SimpleTrigger(String name, String group, Date startTime) {
        this(name, group, startTime, null, 0, 0L);
    }

    public SimpleTrigger(String name, Date startTime, Date endTime, int repeatCount, long repeatInterval) {
        this(name, null, startTime, endTime, repeatCount, repeatInterval);
    }

    public SimpleTrigger(String name, String group, Date startTime, Date endTime, int repeatCount, long repeatInterval) {
        super(name, group);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setRepeatCount(repeatCount);
        this.setRepeatInterval(repeatInterval);
    }

    public SimpleTrigger(String name, String group, String jobName, String jobGroup, Date startTime, Date endTime, int repeatCount, long repeatInterval) {
        super(name, group, jobName, jobGroup);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setRepeatCount(repeatCount);
        this.setRepeatInterval(repeatInterval);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && startTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        if (repeatCount < 0 && repeatCount != -1) {
            throw new IllegalArgumentException("Repeat count must be >= 0, use the constant REPEAT_INDEFINITELY for infinite.");
        }
        this.repeatCount = repeatCount;
    }

    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(long repeatInterval) {
        if (repeatInterval < 0L) {
            throw new IllegalArgumentException("Repeat interval must be >= 0");
        }
        this.repeatInterval = repeatInterval;
    }

    public int getTimesTriggered() {
        return this.timesTriggered;
    }

    public void setTimesTriggered(int timesTriggered) {
        this.timesTriggered = timesTriggered;
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        if (misfireInstruction < 0) {
            return false;
        }
        return misfireInstruction <= 5;
    }

    public void updateAfterMisfire(Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == 0) {
            instr = this.getRepeatCount() == 0 ? 1 : (this.getRepeatCount() == -1 ? 4 : 2);
        } else if (instr == 1 && this.getRepeatCount() != 0) {
            instr = 3;
        }
        if (instr == 1) {
            this.setNextFireTime(new Date());
        } else if (instr == 5) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime()) && (newFireTime = this.getFireTimeAfter(newFireTime)) != null) {
                java.util.Calendar c = java.util.Calendar.getInstance();
                c.setTime(newFireTime);
                if (c.get(1) <= 2299) continue;
                newFireTime = null;
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 4) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime()) && (newFireTime = this.getFireTimeAfter(newFireTime)) != null) {
                java.util.Calendar c = java.util.Calendar.getInstance();
                c.setTime(newFireTime);
                if (c.get(1) <= 2299) continue;
                newFireTime = null;
            }
            if (newFireTime != null) {
                int timesMissed = this.computeNumTimesFiredBetween(this.nextFireTime, newFireTime);
                this.setTimesTriggered(this.getTimesTriggered() + timesMissed);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 2) {
            Date newFireTime = new Date();
            if (this.repeatCount != 0 && this.repeatCount != -1) {
                this.setRepeatCount(this.getRepeatCount() - this.getTimesTriggered());
                this.setTimesTriggered(0);
            }
            if (this.getEndTime() != null && this.getEndTime().before(newFireTime)) {
                this.setNextFireTime(null);
            } else {
                this.setStartTime(newFireTime);
                this.setNextFireTime(newFireTime);
            }
        } else if (instr == 3) {
            Date newFireTime = new Date();
            int timesMissed = this.computeNumTimesFiredBetween(this.nextFireTime, newFireTime);
            if (this.repeatCount != 0 && this.repeatCount != -1) {
                int remainingCount = this.getRepeatCount() - (this.getTimesTriggered() + timesMissed);
                if (remainingCount <= 0) {
                    remainingCount = 0;
                }
                this.setRepeatCount(remainingCount);
                this.setTimesTriggered(0);
            }
            if (this.getEndTime() != null && this.getEndTime().before(newFireTime)) {
                this.setNextFireTime(null);
            } else {
                this.setStartTime(newFireTime);
                this.setNextFireTime(newFireTime);
            }
        }
    }

    public void triggered(Calendar calendar) {
        ++this.timesTriggered;
        this.previousFireTime = this.nextFireTime;
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) <= 2299) continue;
            this.nextFireTime = null;
        }
    }

    public void updateWithNewCalendar(Calendar calendar, long misfireThreshold) {
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        if (this.nextFireTime == null || calendar == null) {
            return;
        }
        Date now = new Date();
        while (this.nextFireTime != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            long diff;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) > 2299) {
                this.nextFireTime = null;
            }
            if (this.nextFireTime == null || !this.nextFireTime.before(now) || (diff = now.getTime() - this.nextFireTime.getTime()) < misfireThreshold) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getStartTime();
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar c = java.util.Calendar.getInstance();
            c.setTime(this.nextFireTime);
            if (c.get(1) <= 2299) continue;
            return null;
        }
        return this.nextFireTime;
    }

    public int executionComplete(JobExecutionContext context, JobExecutionException result) {
        if (result != null && result.refireImmediately()) {
            return 1;
        }
        if (result != null && result.unscheduleFiringTrigger()) {
            return 2;
        }
        if (result != null && result.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public Date getFireTimeAfter(Date afterTime) {
        long endMillis;
        if (this.complete) {
            return null;
        }
        if (this.timesTriggered > this.repeatCount && this.repeatCount != -1) {
            return null;
        }
        if (afterTime == null) {
            afterTime = new Date();
        }
        if (this.repeatCount == 0 && afterTime.compareTo(this.getStartTime()) >= 0) {
            return null;
        }
        long startMillis = this.getStartTime().getTime();
        long afterMillis = afterTime.getTime();
        long l = endMillis = this.getEndTime() == null ? Long.MAX_VALUE : this.getEndTime().getTime();
        if (endMillis <= afterMillis) {
            return null;
        }
        if (afterMillis < startMillis) {
            return new Date(startMillis);
        }
        long numberOfTimesExecuted = (afterMillis - startMillis) / this.repeatInterval + 1L;
        if (numberOfTimesExecuted > (long)this.repeatCount && this.repeatCount != -1) {
            return null;
        }
        Date time = new Date(startMillis + numberOfTimesExecuted * this.repeatInterval);
        if (endMillis <= time.getTime()) {
            return null;
        }
        return time;
    }

    public Date getFireTimeBefore(Date end) {
        if (end.getTime() < this.getStartTime().getTime()) {
            return null;
        }
        int numFires = this.computeNumTimesFiredBetween(this.getStartTime(), end);
        return new Date(this.getStartTime().getTime() + (long)numFires * this.repeatInterval);
    }

    public int computeNumTimesFiredBetween(Date start, Date end) {
        if (this.repeatInterval < 1L) {
            return 0;
        }
        long time = end.getTime() - start.getTime();
        return (int)(time / this.repeatInterval);
    }

    public Date getFinalFireTime() {
        if (this.repeatCount == 0) {
            return this.startTime;
        }
        if (this.repeatCount == -1) {
            return this.getEndTime() == null ? null : this.getFireTimeBefore(this.getEndTime());
        }
        long lastTrigger = this.startTime.getTime() + (long)this.repeatCount * this.repeatInterval;
        if (this.getEndTime() == null || lastTrigger < this.getEndTime().getTime()) {
            return new Date(lastTrigger);
        }
        return this.getFireTimeBefore(this.getEndTime());
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    public void validate() throws SchedulerException {
        super.validate();
        if (this.repeatCount != 0 && this.repeatInterval < 1L) {
            throw new SchedulerException("Repeat Interval cannot be zero.", 100);
        }
    }

    public boolean hasAdditionalProperties() {
        return false;
    }

    public static void main(String[] args) throws Exception {
        Date sdt = new Date();
        Date edt = new Date(sdt.getTime() + 55000L);
        SimpleTrigger st = new SimpleTrigger("t", "g", "j", "g", sdt, edt, 10, 10000L);
        System.err.println();
        st.computeFirstFireTime(null);
        System.err.println("lastTime=" + st.getFinalFireTime());
        List times = TriggerUtils.computeFireTimes(st, null, 50);
        for (int i = 0; i < times.size(); ++i) {
            System.err.println("firetime = " + times.get(i));
        }
    }
}

