/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.config;

import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.ClassOrRefDefinitionParser;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.endpoint.URIBuilder;
import org.mule.transport.tcp.PollingTcpConnector;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpProtocol;
import org.mule.transport.tcp.config.ByteOrMessageProtocolDefinitionParser;
import org.mule.transport.tcp.protocols.CustomClassLoadingLengthProtocol;
import org.mule.transport.tcp.protocols.DirectProtocol;
import org.mule.transport.tcp.protocols.EOFProtocol;
import org.mule.transport.tcp.protocols.LengthProtocol;
import org.mule.transport.tcp.protocols.MuleMessageDirectProtocol;
import org.mule.transport.tcp.protocols.MuleMessageEOFProtocol;
import org.mule.transport.tcp.protocols.MuleMessageLengthProtocol;
import org.mule.transport.tcp.protocols.MuleMessageSafeProtocol;
import org.mule.transport.tcp.protocols.SafeProtocol;
import org.mule.transport.tcp.protocols.StreamingProtocol;
import org.mule.transport.tcp.protocols.XmlMessageEOFProtocol;
import org.mule.transport.tcp.protocols.XmlMessageProtocol;
import org.springframework.beans.factory.xml.BeanDefinitionParser;

public class TcpNamespaceHandler
extends AbstractMuleNamespaceHandler {
    private static final String TCP_PROTOCOL_PROPERTY = "tcpProtocol";

    public void init() {
        this.registerStandardTransportEndpoints("tcp", URIBuilder.SOCKET_ATTRIBUTES);
        this.registerConnectorDefinitionParser(TcpConnector.class);
        this.registerBeanDefinitionParser("polling-connector", (BeanDefinitionParser)new MuleOrphanDefinitionParser(PollingTcpConnector.class, true));
        this.registerBeanDefinitionParser("custom-protocol", (BeanDefinitionParser)new ChildDefinitionParser(TCP_PROTOCOL_PROPERTY, null, TcpProtocol.class, true));
        this.registerBeanDefinitionParser("xml-protocol", (BeanDefinitionParser)new ChildDefinitionParser(TCP_PROTOCOL_PROPERTY, XmlMessageProtocol.class));
        this.registerBeanDefinitionParser("xml-eof-protocol", (BeanDefinitionParser)new ChildDefinitionParser(TCP_PROTOCOL_PROPERTY, XmlMessageEOFProtocol.class));
        this.registerBeanDefinitionParser("safe-protocol", (BeanDefinitionParser)new ByteOrMessageProtocolDefinitionParser(SafeProtocol.class, MuleMessageSafeProtocol.class));
        this.registerBeanDefinitionParser("length-protocol", (BeanDefinitionParser)new ByteOrMessageProtocolDefinitionParser(LengthProtocol.class, MuleMessageLengthProtocol.class));
        this.registerBeanDefinitionParser("eof-protocol", (BeanDefinitionParser)new ByteOrMessageProtocolDefinitionParser(EOFProtocol.class, MuleMessageEOFProtocol.class));
        this.registerBeanDefinitionParser("direct-protocol", (BeanDefinitionParser)new ByteOrMessageProtocolDefinitionParser(DirectProtocol.class, MuleMessageDirectProtocol.class));
        this.registerBeanDefinitionParser("streaming-protocol", (BeanDefinitionParser)new ByteOrMessageProtocolDefinitionParser(StreamingProtocol.class, MuleMessageDirectProtocol.class));
        this.registerBeanDefinitionParser("custom-protocol", (BeanDefinitionParser)new ClassOrRefDefinitionParser(TCP_PROTOCOL_PROPERTY));
        this.registerBeanDefinitionParser("custom-class-loading-protocol", (BeanDefinitionParser)new ByteOrMessageProtocolDefinitionParser(CustomClassLoadingLengthProtocol.class, CustomClassLoadingLengthProtocol.class));
    }
}

