/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang.SerializationException;
import org.mule.api.MuleContext;
import org.mule.util.store.DeserializationPostInitialisable;

public class SerializationUtils
extends org.apache.commons.lang.SerializationUtils {
    public static Object deserialize(InputStream inputStream, MuleContext muleContext) {
        if (muleContext == null) {
            throw new IllegalArgumentException("The MuleContext must not be null");
        }
        return SerializationUtils.deserialize(inputStream, muleContext.getExecutionClassLoader(), muleContext);
    }

    public static Object deserialize(byte[] objectData, MuleContext muleContext) {
        if (muleContext == null) {
            throw new IllegalArgumentException("The MuleContext must not be null");
        }
        return SerializationUtils.deserialize(objectData, muleContext.getExecutionClassLoader(), muleContext);
    }

    private static Object deserialize(InputStream inputStream, ClassLoader cl, MuleContext muleContext) {
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("The ClassLoader must not be null");
        }
        ClassLoaderObjectInputStream in = null;
        try {
            in = new ClassLoaderObjectInputStream(cl, inputStream);
            Object obj = in.readObject();
            if (obj instanceof DeserializationPostInitialisable) {
                DeserializationPostInitialisable.Implementation.init(obj, muleContext);
            }
            Object object = obj;
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private static Object deserialize(byte[] objectData, ClassLoader cl, MuleContext muleContext) {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        return SerializationUtils.deserialize(bais, cl, muleContext);
    }

    public static Object deserialize(InputStream inputStream, ClassLoader cl) {
        return SerializationUtils.deserialize(inputStream, cl, null);
    }

    public static Object deserialize(byte[] objectData, ClassLoader cl) {
        return SerializationUtils.deserialize(objectData, cl, null);
    }
}

