/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.store.PartitionableExpirableObjectStore;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.util.concurrent.DaemonThreadFactory;
import org.mule.util.store.MonitoredObjectStoreWrapper;
import org.mule.util.store.ObjectStorePartition;
import org.mule.util.store.PartitionedObjectStoreWrapper;

public class MuleObjectStoreManager
implements ObjectStoreManager,
MuleContextAware,
Initialisable,
Disposable {
    MuleContext muleContext;
    ConcurrentMap<String, ObjectStore<?>> stores = new ConcurrentHashMap();
    protected ScheduledThreadPoolExecutor scheduler;
    private static Log logger = LogFactory.getLog(MuleObjectStoreManager.class);

    @Override
    public <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name) {
        return this.getObjectStore(name, false);
    }

    @Override
    public <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name, boolean isPersistent) {
        return this.getObjectStore(name, isPersistent, 0, 0, 0);
    }

    @Override
    public synchronized <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name, boolean isPersistent, int maxEntries, int entryTTL, int expirationInterval) {
        if (this.stores.containsKey(name)) {
            return (T)((ObjectStore)this.stores.get(name));
        }
        ListableObjectStore baseStore = isPersistent ? (ListableObjectStore)this.muleContext.getRegistry().lookupObject("_defaultPersistentObjectStore") : (ListableObjectStore)this.muleContext.getRegistry().lookupObject("_defaultInMemoryObjectStore");
        T store = this.getPartitionFromBaseObjectStore(baseStore, name);
        if (maxEntries == 0) {
            return this.putInStoreMap(name, store);
        }
        return this.getMonitorablePartition(name, baseStore, store, entryTTL, maxEntries, expirationInterval);
    }

    private <T extends ObjectStore<? extends Serializable>> T getPartitionFromBaseObjectStore(ListableObjectStore baseStore, String partitionName) {
        if (baseStore instanceof PartitionableObjectStore) {
            return (T)new ObjectStorePartition(partitionName, (PartitionableObjectStore)baseStore);
        }
        return (T)new PartitionedObjectStoreWrapper(partitionName, this.muleContext, baseStore);
    }

    private <T extends ObjectStore<? extends Serializable>> T putInStoreMap(String name, T store) {
        ObjectStore<?> previous = this.stores.putIfAbsent(name, store);
        if (previous == null) {
            return store;
        }
        return (T)previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ObjectStore<? extends Serializable>> T getMonitorablePartition(String name, ListableObjectStore baseStore, T store, int entryTTL, int maxEntries, int expirationInterval) {
        MonitoredObjectStoreWrapper monObjectStore;
        if (baseStore instanceof PartitionableExpirableObjectStore) {
            ObjectStore<?> previous = this.stores.putIfAbsent(name, store);
            if (previous == null) {
                Monitor m = new Monitor(name, (PartitionableExpirableObjectStore)baseStore, entryTTL, maxEntries);
                this.scheduler.scheduleWithFixedDelay(m, 0L, expirationInterval, TimeUnit.MILLISECONDS);
                return store;
            }
            return (T)previous;
        }
        MuleObjectStoreManager muleObjectStoreManager = this;
        synchronized (muleObjectStoreManager) {
            if (this.stores.containsKey(name)) {
                return (T)((ObjectStore)this.stores.get(name));
            }
            monObjectStore = new MonitoredObjectStoreWrapper((ListableObjectStore)store, maxEntries, entryTTL, expirationInterval);
            monObjectStore.setMuleContext(this.muleContext);
            try {
                monObjectStore.initialise();
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException(e);
            }
            this.stores.put(name, monObjectStore);
        }
        return (T)monObjectStore;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void clearStoreCache() {
        this.stores.clear();
    }

    @Override
    public void dispose() {
        this.scheduler.shutdown();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.scheduler = new ScheduledThreadPoolExecutor(1);
        this.scheduler.setThreadFactory(new DaemonThreadFactory("ObjectStoreManager-Monitor", this.getClass().getClassLoader()));
    }

    @Override
    public void disposeStore(ObjectStore<? extends Serializable> store) throws ObjectStoreException {
        if (store instanceof ObjectStorePartition) {
            ObjectStorePartition partition = (ObjectStorePartition)store;
            partition.getBaseStore().disposePartition(partition.getPartitionName());
        } else if (store instanceof ListableObjectStore) {
            List<Serializable> keys;
            ListableObjectStore listableStore = (ListableObjectStore)store;
            while ((keys = listableStore.allKeys()).size() != 0) {
                for (Serializable key : keys) {
                    listableStore.remove(key);
                }
            }
        }
    }

    class Monitor
    implements Runnable {
        private final String partitionName;
        private final PartitionableExpirableObjectStore<? extends Serializable> store;
        private final int entryTTL;
        private final int maxEntries;

        public Monitor(String partitionName, PartitionableExpirableObjectStore<? extends Serializable> store, int entryTTL, int maxEntries) {
            this.partitionName = partitionName;
            this.store = store;
            this.entryTTL = entryTTL;
            this.maxEntries = maxEntries;
        }

        @Override
        public void run() {
            if (MuleObjectStoreManager.this.muleContext.isPrimaryPollingInstance()) {
                try {
                    this.store.expire(this.entryTTL, this.maxEntries, this.partitionName);
                }
                catch (Exception e) {
                    logger.warn((Object)("Running expirty on partition " + this.partitionName + " of " + this.store + " threw " + e + ":" + e.getMessage()));
                }
            }
        }
    }
}

