/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.TaskAssign;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignTaskCmd
extends AbstractCommand<Void> {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String userId;
    protected boolean take;

    public AssignTaskCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public AssignTaskCmd(String taskId, String userId, boolean take) {
        this.taskId = taskId;
        this.userId = userId;
        this.take = take;
    }

    public Void execute(Environment environment) {
        DbSession dbSession = (DbSession)environment.get(DbSession.class);
        TaskImpl task = dbSession.get(TaskImpl.class, Long.parseLong(this.taskId));
        if (task == null) {
            throw new JbpmException("task " + this.taskId + " does not exist");
        }
        if (this.take) {
            task.take(this.userId);
        } else {
            task.setAssignee(this.userId, true);
        }
        HistoryEvent.fire(new TaskAssign(task, this.userId));
        return null;
    }
}

