/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.usercode;

import java.io.Serializable;
import org.jbpm.api.Execution;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.internal.wire.Descriptor;

public class UserCodeReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean isCached = true;
    protected Object cachedObject;
    protected Descriptor descriptor;

    public Object getObject(Execution execution) {
        return this.getObject(null, execution);
    }

    public Object getObject(ProcessDefinitionImpl processDefinition) {
        return this.getObject(processDefinition, null);
    }

    protected Object getObject(ProcessDefinitionImpl processDefinition, Execution execution) {
        if (this.cachedObject != null) {
            return this.cachedObject;
        }
        if (this.descriptor != null) {
            if (processDefinition == null) {
                processDefinition = this.getProcessDefinition(execution);
            }
            Object usedObject = ReflectUtil.instantiateUserCode(this.descriptor, processDefinition, (ScopeInstanceImpl)execution);
            if (this.isCached) {
                this.cachedObject = usedObject;
            }
            return usedObject;
        }
        return null;
    }

    protected ProcessDefinitionImpl getProcessDefinition(Execution execution) {
        ExecutionImpl executionImpl = (ExecutionImpl)execution;
        ActivityImpl activity = executionImpl.getActivity();
        if (activity != null) {
            return activity.getProcessDefinition();
        }
        TransitionImpl transition = executionImpl.getTransition();
        if (transition != null) {
            return transition.getProcessDefinition();
        }
        return null;
    }

    public void setCached(boolean isCached) {
        this.isCached = isCached;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }
}

