/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public abstract class AbstractXMLInputFactory
extends XMLInputFactory {
    private XMLEventAllocator allocator;
    private XMLResolver resolver;
    private XMLReporter reporter;

    @Override
    public XMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
        try {
            return this.createXMLStreamReader(new InputStreamReader(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputStream input = streamSource.getInputStream();
            if (input != null) {
                if (streamSource.getSystemId() != null) {
                    return this.createXMLStreamReader(streamSource.getSystemId(), input);
                }
                return this.createXMLStreamReader(input);
            }
            Reader reader = streamSource.getReader();
            if (reader != null) {
                if (streamSource.getSystemId() != null) {
                    return this.createXMLStreamReader(streamSource.getSystemId(), reader);
                }
                return this.createXMLStreamReader(reader);
            }
            if (streamSource.getSystemId() != null) {
                try {
                    return this.createXMLStreamReader(streamSource.getSystemId(), new URI(source.getSystemId()).toURL().openStream());
                }
                catch (Exception e) {
                    throw new XMLStreamException("Cannot open system id as URL for reading: " + source.getSystemId(), e);
                }
            }
            throw new XMLStreamException("Invalid stream source: none of input, reader, systemId set");
        }
        throw new XMLStreamException("Unsupported source type: " + source.getClass());
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.createXMLStreamReader(stream);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        return this.createXMLStreamReader(reader);
    }

    @Override
    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(systemId, reader));
    }

    @Override
    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(source));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(stream));
    }

    @Override
    public XMLEventReader createXMLEventReader(InputStream stream, String encoding) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(stream, encoding));
    }

    @Override
    public XMLEventReader createXMLEventReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.createXMLEventReader(this.createXMLStreamReader(systemId, stream));
    }

    @Override
    public XMLStreamReader createFilteredReader(XMLStreamReader reader, final StreamFilter filter) throws XMLStreamException {
        return new StreamReaderDelegate(reader){

            @Override
            public boolean hasNext() throws XMLStreamException {
                while (super.hasNext()) {
                    if (filter.accept(this.getParent())) {
                        return true;
                    }
                    super.next();
                }
                return false;
            }

            @Override
            public int next() throws XMLStreamException {
                if (this.hasNext()) {
                    return this.getParent().getEventType();
                }
                throw new IllegalStateException("No more events");
            }
        };
    }

    @Override
    public XMLEventAllocator getEventAllocator() {
        return this.allocator;
    }

    @Override
    public void setEventAllocator(XMLEventAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public XMLResolver getXMLResolver() {
        return this.resolver;
    }

    @Override
    public void setXMLResolver(XMLResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public XMLReporter getXMLReporter() {
        return this.reporter;
    }

    @Override
    public void setXMLReporter(XMLReporter reporter) {
        this.reporter = reporter;
    }
}

