/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon;

import de.odysseus.staxon.AbstractXMLStreamScope;
import de.odysseus.staxon.Pair;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class XMLStreamReaderScope<T>
extends AbstractXMLStreamScope {
    private List<Pair<String, String>> declarations;
    private List<Pair<QName, String>> attributes;
    private T info;

    public XMLStreamReaderScope(String defaultNamespace, T info) {
        super(defaultNamespace);
        this.info = info;
    }

    public XMLStreamReaderScope(NamespaceContext parent, T info) {
        super(parent);
        this.info = info;
    }

    public XMLStreamReaderScope(XMLStreamReaderScope<T> parent, String prefix, String localName) {
        super(parent, prefix, localName);
    }

    public T getInfo() {
        return this.info;
    }

    public void setInfo(T info) {
        this.info = info;
    }

    @Override
    public XMLStreamReaderScope<T> getParent() {
        return (XMLStreamReaderScope)super.getParent();
    }

    public int getNamespaceCount() {
        return this.declarations == null ? 0 : this.declarations.size();
    }

    public String getNamespacePrefix(int index) {
        return this.declarations == null ? null : this.declarations.get(index).getFirst();
    }

    public String getNamespaceURI(int index) {
        return this.declarations == null ? null : this.declarations.get(index).getSecond();
    }

    void addNamespaceURI(String prefix, String namespaceURI) {
        if (this.declarations == null) {
            this.declarations = new LinkedList<Pair<String, String>>();
        }
        this.declarations.add(new Pair<String, String>(prefix, namespaceURI));
        this.setPrefix(prefix, namespaceURI);
    }

    void addAttribute(QName name, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedList<Pair<QName, String>>();
        }
        this.attributes.add(new Pair<QName, String>(name, value));
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public QName getAttributeName(int index) {
        return this.attributes.get(index).getFirst();
    }

    public String getAttributeValue(int index) {
        return this.attributes.get(index).getSecond();
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        if (this.attributes != null) {
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            for (Pair<QName, String> attribute : this.attributes) {
                if (!localName.equals(attribute.getFirst().getLocalPart()) || !namespaceURI.equals(attribute.getFirst().getNamespaceURI())) continue;
                return attribute.getSecond();
            }
        }
        return null;
    }
}

