/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json;

import de.odysseus.staxon.AbstractXMLStreamReader;
import de.odysseus.staxon.XMLStreamReaderScope;
import de.odysseus.staxon.json.JsonXMLStreamScopeInfo;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class JsonXMLStreamReader
extends AbstractXMLStreamReader<ScopeInfo> {
    private final JsonStreamSource source;
    private final boolean multiplePI;

    public JsonXMLStreamReader(JsonStreamSource source, boolean multiplePI) throws XMLStreamException {
        super(new ScopeInfo());
        this.source = source;
        this.multiplePI = multiplePI;
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void consumeName(XMLStreamReaderScope<ScopeInfo> scope) throws XMLStreamException, IOException {
        String fieldName = this.source.name();
        if (fieldName.startsWith("@")) {
            fieldName = fieldName.substring(1);
            if (this.source.peek() == JsonStreamToken.VALUE) {
                this.readAttr(fieldName, this.source.value());
                return;
            } else {
                if (!"xmlns".equals(fieldName)) throw new IllegalStateException("Expected attribute value");
                this.source.startObject();
                while (this.source.peek() == JsonStreamToken.NAME) {
                    String prefix = this.source.name();
                    if ("$".equals(prefix)) {
                        this.readAttr("xmlns", this.source.value());
                        continue;
                    }
                    this.readAttr("xmlns:" + prefix, this.source.value());
                }
                this.source.endObject();
            }
            return;
        } else if ("$".equals(fieldName)) {
            this.readText(this.source.value(), 4);
            return;
        } else {
            scope.getInfo().currentTagName = fieldName;
        }
    }

    @Override
    protected boolean consume(XMLStreamReaderScope<ScopeInfo> scope) throws XMLStreamException, IOException {
        switch (this.source.peek()) {
            case NAME: {
                this.consumeName(scope);
                return this.consume(scope);
            }
            case START_ARRAY: {
                this.source.startArray();
                if (scope.getInfo().getArrayName() != null) {
                    throw new IOException("Array start inside array");
                }
                if (scope.getInfo().currentTagName == null) {
                    throw new IOException("Array name missing");
                }
                scope.getInfo().startArray(scope.getInfo().currentTagName);
                if (this.multiplePI) {
                    this.readPI("xml-multiple", scope.getInfo().currentTagName);
                }
                return this.consume(scope);
            }
            case START_OBJECT: {
                this.source.startObject();
                if (scope.isRoot() && scope.getInfo().currentTagName == null) {
                    this.readStartDocument(null, null, null);
                } else {
                    if (scope.getInfo().getArrayName() != null) {
                        scope.getInfo().incArraySize();
                    }
                    scope = this.readStartElementTag(scope.getInfo().currentTagName);
                    scope.setInfo(new ScopeInfo());
                }
                return this.consume(scope);
            }
            case END_OBJECT: {
                this.source.endObject();
                if (scope.isRoot()) {
                    this.readEndDocument();
                    return false;
                }
                this.readEndElementTag();
                return true;
            }
            case VALUE: {
                String text = this.source.value();
                String name = scope.getInfo().currentTagName;
                if (scope.getInfo().getArrayName() != null) {
                    scope.getInfo().incArraySize();
                    name = scope.getInfo().getArrayName();
                }
                this.readStartElementTag(name);
                if (text != null) {
                    this.readText(text, 4);
                }
                this.readEndElementTag();
                return true;
            }
            case END_ARRAY: {
                this.source.endArray();
                if (scope.getInfo().getArrayName() == null) {
                    throw new IllegalStateException("Array end without matching start");
                }
                scope.getInfo().endArray();
                return true;
            }
            case NONE: {
                return false;
            }
        }
        throw new IOException("Unexpected token: " + (Object)((Object)this.source.peek()));
    }

    @Override
    public void close() throws XMLStreamException {
        super.close();
        try {
            this.source.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    static class ScopeInfo
    extends JsonXMLStreamScopeInfo {
        private String currentTagName;

        ScopeInfo() {
        }
    }
}

