/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.gson;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.odysseus.staxon.json.stream.JsonStreamFactory;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import de.odysseus.staxon.json.stream.gson.GsonStreamSource;
import de.odysseus.staxon.json.stream.gson.GsonStreamTarget;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class GsonStreamFactory
extends JsonStreamFactory {
    @Override
    public JsonStreamSource createJsonStreamSource(InputStream input) throws IOException {
        return this.createJsonStreamSource(new InputStreamReader(input));
    }

    @Override
    public JsonStreamSource createJsonStreamSource(Reader reader) {
        JsonReader jsonReader = new JsonReader((Reader)new FilterReader(reader){

            @Override
            public void close() throws IOException {
            }
        });
        jsonReader.setLenient(false);
        return new GsonStreamSource(jsonReader);
    }

    @Override
    public JsonStreamTarget createJsonStreamTarget(OutputStream output, boolean pretty) throws IOException {
        return this.createJsonStreamTarget(new OutputStreamWriter(output), pretty);
    }

    @Override
    public JsonStreamTarget createJsonStreamTarget(Writer writer, boolean pretty) {
        JsonWriter jsonWriter = new JsonWriter((Writer)new FilterWriter(writer){

            @Override
            public void close() throws IOException {
                this.flush();
            }
        });
        jsonWriter.setLenient(false);
        jsonWriter.setIndent(pretty ? "\t" : "");
        return new GsonStreamTarget(jsonWriter);
    }
}

