/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.util;

import de.odysseus.staxon.json.stream.JsonStreamTarget;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Stack;

public class AutoArrayTarget
implements JsonStreamTarget {
    static final Event START_OBJECT = new Event(){

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.startObject();
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.START_OBJECT;
        }

        public String toString() {
            return this.token().name();
        }
    };
    static final Event END_OBJECT = new Event(){

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.endObject();
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.END_OBJECT;
        }

        public String toString() {
            return this.token().name();
        }
    };
    static final Event END_ARRAY = new Event(){

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.endArray();
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.END_ARRAY;
        }

        public String toString() {
            return this.token().name();
        }
    };
    private final JsonStreamTarget delegate;
    private final Deque<Event> events = new LinkedList<Event>();
    private final Stack<NameEvent> fields = new Stack();

    public AutoArrayTarget(JsonStreamTarget delegate) {
        this.delegate = delegate;
    }

    private void pushField(String name) {
        this.events.add(this.fields.push(new NameEvent(name)));
    }

    private void popField() {
        if (this.fields.peek().isArray()) {
            this.events.add(END_ARRAY);
        }
        this.fields.pop();
    }

    @Override
    public void name(String name) throws IOException {
        if (this.events.peekLast().token() == JsonStreamToken.START_OBJECT) {
            this.pushField(name);
        } else if (name.equals(this.fields.peek().name())) {
            this.fields.peek().setArray(true);
        } else {
            this.popField();
            this.pushField(name);
        }
    }

    @Override
    public void value(String value) throws IOException {
        this.events.add(new ValueEvent(value));
    }

    @Override
    public void startObject() throws IOException {
        this.events.add(START_OBJECT);
    }

    @Override
    public void endObject() throws IOException {
        this.popField();
        this.events.add(END_OBJECT);
        if (this.fields.isEmpty()) {
            while (!this.events.isEmpty()) {
                this.events.pollFirst().write(this.delegate);
            }
        }
    }

    @Override
    public void startArray() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void endArray() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void close() throws IOException {
        while (!this.events.isEmpty()) {
            this.events.pollFirst().write(this.delegate);
        }
        this.delegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    static final class ValueEvent
    implements Event {
        final String value;

        ValueEvent(String value) {
            this.value = value;
        }

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.value(this.value);
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.VALUE;
        }

        public String toString() {
            return this.token().name() + " = " + this.value;
        }
    }

    static final class NameEvent
    implements Event {
        final String name;
        boolean array;

        NameEvent(String name) {
            this.name = name;
        }

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.name(this.name);
            if (this.array) {
                target.startArray();
            }
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.NAME;
        }

        public String name() {
            return this.name;
        }

        public boolean isArray() {
            return this.array;
        }

        public void setArray(boolean array) {
            this.array = array;
        }

        public String toString() {
            if (this.array) {
                return this.token().name() + " = " + this.name + " " + (Object)((Object)JsonStreamToken.START_ARRAY);
            }
            return this.token().name() + " = " + this.name;
        }
    }

    static interface Event {
        public JsonStreamToken token();

        public void write(JsonStreamTarget var1) throws IOException;
    }
}

