/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.xml;

import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

class PrettyXMLWhitespaceHandler {
    private static final int MAX_DEPTH = 64;
    private final WhitespaceEvent newline;
    private final WhitespaceEvent[] indent;
    private final WhitespaceWriter writer;
    private int depth = 0;
    private boolean text = false;
    private boolean leaf = false;

    PrettyXMLWhitespaceHandler(final XMLStreamWriter writer, String indentation, String newline) {
        this(indentation, newline, new WhitespaceWriter(){

            @Override
            public void add(WhitespaceEvent event) throws XMLStreamException {
                writer.writeCharacters(event.getData());
            }
        });
    }

    PrettyXMLWhitespaceHandler(final XMLEventWriter writer, String indentation, String newline) {
        this(indentation, newline, new WhitespaceWriter(){

            @Override
            public void add(WhitespaceEvent event) throws XMLStreamException {
                writer.add(event);
            }
        });
    }

    private PrettyXMLWhitespaceHandler(String indentation, String newline, WhitespaceWriter writer) {
        this.newline = new WhitespaceEvent(newline, "<<newline>>");
        this.indent = new WhitespaceEvent[64];
        this.writer = writer;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.indent.length; ++i) {
            this.indent[i] = new WhitespaceEvent(builder.toString(), "<<indentation>>");
            builder.append(indentation);
        }
    }

    private void preStructure() throws XMLStreamException {
        if (this.text) {
            this.text = false;
        } else if (this.depth > 0) {
            this.writer.add(this.newline);
            this.writer.add(this.indent[this.depth]);
        }
    }

    private void postComment_PI() throws XMLStreamException {
        this.leaf = false;
        if (this.depth == 0) {
            this.writer.add(this.newline);
        }
    }

    void preStartDocument() throws XMLStreamException {
        this.preStructure();
    }

    void postStartDocument() throws XMLStreamException {
        this.postComment_PI();
    }

    void preComment() throws XMLStreamException {
        this.preStructure();
    }

    void postComment() throws XMLStreamException {
        this.postComment_PI();
    }

    void preProcessingInstruction() throws XMLStreamException {
        this.preStructure();
    }

    void postProcessingInstruction() throws XMLStreamException {
        this.postComment_PI();
    }

    void preStartElement() throws XMLStreamException {
        this.preStructure();
    }

    void postStartElement() throws XMLStreamException {
        ++this.depth;
        this.leaf = true;
    }

    void preEndElement() throws XMLStreamException {
        --this.depth;
        if (this.text) {
            this.text = false;
        } else if (!this.leaf) {
            this.writer.add(this.newline);
            if (this.depth > 0) {
                this.writer.add(this.indent[this.depth]);
            }
        }
    }

    void postEndElement() throws XMLStreamException {
        this.leaf = false;
    }

    void preEmptyELement() throws XMLStreamException {
        this.preStructure();
    }

    void postEmptyELement() throws XMLStreamException {
        this.leaf = false;
    }

    void preCharacters() {
        this.text = true;
    }

    void postCharacters() {
    }

    void preEndDocument() throws XMLStreamException {
    }

    void postEndDocument() throws XMLStreamException {
        this.writer.add(this.newline);
    }

    static abstract class WhitespaceWriter {
        WhitespaceWriter() {
        }

        abstract void add(WhitespaceEvent var1) throws XMLStreamException;
    }

    static class WhitespaceEvent
    implements Characters {
        final String whitespace;
        final String description;

        WhitespaceEvent(String whitespace, String description) {
            this.whitespace = whitespace;
            this.description = description;
        }

        @Override
        public Characters asCharacters() {
            return this;
        }

        @Override
        public StartElement asStartElement() {
            return null;
        }

        @Override
        public EndElement asEndElement() {
            return null;
        }

        @Override
        public int getEventType() {
            return 4;
        }

        @Override
        public Location getLocation() {
            return null;
        }

        @Override
        public QName getSchemaType() {
            return null;
        }

        @Override
        public boolean isAttribute() {
            return false;
        }

        @Override
        public boolean isCharacters() {
            return true;
        }

        @Override
        public boolean isEndDocument() {
            return false;
        }

        @Override
        public boolean isEndElement() {
            return false;
        }

        @Override
        public boolean isEntityReference() {
            return false;
        }

        @Override
        public boolean isNamespace() {
            return false;
        }

        @Override
        public boolean isProcessingInstruction() {
            return false;
        }

        @Override
        public boolean isStartDocument() {
            return false;
        }

        @Override
        public boolean isStartElement() {
            return false;
        }

        public String toString() {
            return this.description;
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        }

        @Override
        public String getData() {
            return this.whitespace;
        }

        @Override
        public boolean isCData() {
            return false;
        }

        @Override
        public boolean isIgnorableWhiteSpace() {
            return false;
        }

        @Override
        public boolean isWhiteSpace() {
            return true;
        }
    }
}

