/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.ArrayList;
import java.util.Properties;
import javax.resource.spi.work.WorkListener;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.WorkManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.lifecycle.MuleContextLifecycleManager;
import org.mule.model.seda.SedaModel;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Banana;

public class DefaultMuleContextFactoryTestCase
extends AbstractMuleTestCase {
    private DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
    private static String TEST_STRING_KEY = "test";
    private static String TEST_STRING_VALUE = "test_value";
    private static String TEST_STRING_KEY2 = "test2";
    private static String TEST_STRING_VALUE2 = "test_value2";
    private static String TEST_OBJECT_NAME = "testObject";
    private static String TEST_MODEL_NAME = "testModel";

    @Test
    public void testCreateMuleContext() throws InitialisationException, ConfigurationException {
        MuleContext context = this.muleContextFactory.createMuleContext();
        this.assertMuleContextConfiguration(context);
        this.assertDefaults(context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilder() throws InitialisationException, ConfigurationException {
        MuleContext context = this.muleContextFactory.createMuleContext((ConfigurationBuilder)new TestConfigurationBuilder());
        this.assertMuleContextConfiguration(context);
        this.assertConfigurationBuilder1Objects(context);
        this.assertNoDefaults(context);
    }

    @Test
    public void testCreateMuleContextListMuleContextBuilder() throws InitialisationException, ConfigurationException {
        ArrayList<AbstractConfigurationBuilder> configBuilders = new ArrayList<AbstractConfigurationBuilder>();
        configBuilders.add(new TestConfigurationBuilder());
        configBuilders.add(new TestConfigurationBuilder2());
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        MuleContext context = this.muleContextFactory.createMuleContext(configBuilders, (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(context);
        this.assertConfigurationBuilder1Objects(context);
        this.assertConfigurationBuilder2Objects(context);
        this.assertNoDefaults(context);
    }

    @Test
    public void testCreateMuleContextMuleContextBuilder() throws InitialisationException, ConfigurationException {
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        MuleContext context = this.muleContextFactory.createMuleContext((ConfigurationBuilder)new SimpleConfigurationBuilder(null), (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(context);
        this.assertNoDefaults(context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilderMuleContextBuilder() throws InitialisationException, ConfigurationException {
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        MuleContext context = this.muleContextFactory.createMuleContext((ConfigurationBuilder)new TestConfigurationBuilder2(), (MuleContextBuilder)muleContextBuilder);
        this.assertCustomMuleContext(context);
        this.assertConfigurationBuilder2Objects(context);
        this.assertNoDefaults(context);
    }

    @Test
    public void testCreateMuleContextString() throws InitialisationException, ConfigurationException {
        MuleContext context = null;
        try {
            context = this.muleContextFactory.createMuleContext("log4j.properties");
        }
        catch (ConfigurationException e) {
            Assert.assertEquals((Object)"No suitable configuration builder for resource \"[ConfigResource{resourceName='log4j.properties'}]\" found.  Check you have configuration module on your classpath and are using correct file extension. (org.mule.api.config.ConfigurationException)", (Object)e.getMessage());
        }
        Assert.assertNull((Object)context);
    }

    @Test
    public void testCreateMuleContextStringProperties() throws InitialisationException, ConfigurationException {
        Properties properties = new Properties();
        properties.put("testKey1", "testValue1");
        properties.put("testKey2", "testValue2");
        MuleContext context = null;
        try {
            context = this.muleContextFactory.createMuleContext("log4j.properties", properties);
        }
        catch (ConfigurationException e) {
            Assert.assertEquals((Object)"No suitable configuration builder for resource \"[ConfigResource{resourceName='log4j.properties'}]\" found.  Check you have configuration module on your classpath and are using correct file extension. (org.mule.api.config.ConfigurationException)", (Object)e.getMessage());
        }
        Assert.assertNull((Object)context);
    }

    @Test
    public void testCreateMuleContextConfigurationBuilderProperties() throws InitialisationException, ConfigurationException {
        Properties properties = new Properties();
        properties.put("testKey3", "testValue3");
        properties.put("testKey4", "testValue4");
        MuleContext context = this.muleContextFactory.createMuleContext((ConfigurationBuilder)new TestConfigurationBuilder(), properties);
        this.assertMuleContextConfiguration(context);
        this.assertConfigurationBuilder1Objects(context);
        Assert.assertEquals((Object)"testValue3", (Object)context.getRegistry().lookupObject("testKey3"));
        Assert.assertEquals((Object)"testValue4", (Object)context.getRegistry().lookupObject("testKey4"));
        this.assertNoDefaults(context);
    }

    private void assertDefaults(MuleContext context) {
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_muleQueueManager"));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_muleSecurityManager"));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_defaultInMemoryObjectStore"));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_defaultInMemoryQueueStore"));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_muleSystemModel"));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_muleEndpointFactory"));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupObject("_muleSimpleRegistryBootstrap"));
    }

    private void assertNoDefaults(MuleContext context) {
        Assert.assertNull((Object)context.getRegistry().lookupObject("_muleQueueManager"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_muleSecurityManager"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_defaultInMemoryObjectStore"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_defaultInMemoryQueueStore"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_muleSystemModel"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_muleEndpointFactory"));
        Assert.assertNull((Object)context.getRegistry().lookupObject("_muleSimpleRegistryBootstrap"));
    }

    private void assertMuleContextConfiguration(MuleContext context) {
        junit.framework.Assert.assertNotNull((Object)context);
        Assert.assertEquals(DefaultMuleContext.class, context.getClass());
        Assert.assertTrue((boolean)context.isInitialised());
        junit.framework.Assert.assertNotNull((Object)context.getConfiguration());
        Assert.assertEquals(DefaultMuleConfiguration.class, context.getConfiguration().getClass());
        junit.framework.Assert.assertNotNull(context.getLifecycleManager().getClass());
        junit.framework.Assert.assertNotNull((Object)context.getNotificationManager());
        junit.framework.Assert.assertNotNull((Object)context.getWorkManager());
    }

    private void assertCustomMuleContext(MuleContext context) {
        junit.framework.Assert.assertNotNull((Object)context);
        Assert.assertEquals(TestMuleContext.class, context.getClass());
        Assert.assertTrue((boolean)context.isInitialised());
        junit.framework.Assert.assertNotNull((Object)context.getConfiguration());
        junit.framework.Assert.assertNotNull(context.getLifecycleManager().getClass());
        junit.framework.Assert.assertNotNull((Object)context.getNotificationManager());
        junit.framework.Assert.assertNotNull((Object)context.getWorkManager());
    }

    private void assertConfigurationBuilder1Objects(MuleContext context) {
        Assert.assertEquals((Object)TEST_STRING_VALUE, (Object)context.getRegistry().lookupObject(TEST_STRING_KEY));
        Object obj = context.getRegistry().lookupObject(TEST_OBJECT_NAME);
        junit.framework.Assert.assertNotNull((Object)obj);
        Assert.assertEquals(Banana.class, obj.getClass());
    }

    private void assertConfigurationBuilder2Objects(MuleContext context) {
        Assert.assertEquals((Object)TEST_STRING_VALUE2, (Object)context.getRegistry().lookupObject(TEST_STRING_KEY2));
        junit.framework.Assert.assertNotNull((Object)context.getRegistry().lookupModel(TEST_MODEL_NAME));
        Assert.assertEquals((Object)TEST_MODEL_NAME, (Object)context.getRegistry().lookupModel(TEST_MODEL_NAME).getName());
    }

    static class TestMuleConfiguration
    extends DefaultMuleConfiguration {
        TestMuleConfiguration() {
        }
    }

    static class TestMuleContext
    extends DefaultMuleContext {
        public TestMuleContext(MuleConfiguration config, WorkManager workManager, WorkListener workListener, MuleContextLifecycleManager lifecycleManager, ServerNotificationManager notificationManager) {
            super(config, workManager, workListener, lifecycleManager, notificationManager);
        }
    }

    static class TestMuleContextBuilder
    extends DefaultMuleContextBuilder {
        TestMuleContextBuilder() {
        }

        public MuleContext buildMuleContext() {
            MuleContextLifecycleManager manager = this.getLifecycleManager();
            TestMuleContext context = new TestMuleContext(this.getMuleConfiguration(), this.getWorkManager(), this.getWorkListener(), manager, this.getNotificationManager());
            manager.setMuleContext((MuleContext)context);
            return context;
        }
    }

    static class TestConfigurationBuilder2
    extends AbstractConfigurationBuilder {
        TestConfigurationBuilder2() {
        }

        protected void doConfigure(MuleContext context) throws Exception {
            context.getRegistry().registerObject(TEST_STRING_KEY2, (Object)TEST_STRING_VALUE2);
            SedaModel testModel = new SedaModel();
            testModel.setName(TEST_MODEL_NAME);
            context.getRegistry().registerModel((Model)testModel);
        }
    }

    static class TestConfigurationBuilder
    extends AbstractConfigurationBuilder {
        TestConfigurationBuilder() {
        }

        protected void doConfigure(MuleContext context) throws Exception {
            context.getRegistry().registerObject(TEST_STRING_KEY, (Object)TEST_STRING_VALUE);
            context.getRegistry().registerObject(TEST_OBJECT_NAME, (Object)new Banana());
        }
    }
}

