/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.DataTypeConversionResolver;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.builder.MockTransformerBuilder;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;

@SmallTest
public class DefaultMuleMessageTransformationTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private DataTypeConversionResolver conversionResolver = (DataTypeConversionResolver)Mockito.mock(DataTypeConversionResolver.class);
    private static final DataType<Object> dataTypeB = new SimpleDataType(B.class);
    private static final DataType<Object> dataTypeC = new SimpleDataType(C.class);
    private static final DataType<Object> dataTypeD = new SimpleDataType(D.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleContext.getDataTypeConverterResolver()).thenReturn((Object)this.conversionResolver);
    }

    @Test
    public void failsOnConverterWhenSourceAndReturnTypeDoesNotMatchAndThereIsNoImplicitConversion() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted((Transformer)converter1);
    }

    @Test
    public void appliesImplicitConversionOnConverterWhenSourceAndReturnTypeDoesNotMatch() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).returning(new D())).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).returning(new C())).build();
        Mockito.when((Object)this.conversionResolver.resolve((DataType)Mockito.any(DataType.class), Mockito.anyList())).thenReturn((Object)converter2);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        this.verifyTransformerExecuted((Transformer)converter1);
        this.verifyTransformerExecuted((Transformer)converter2);
    }

    @Test
    public void appliesConverter() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).returning(new C())).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload() instanceof C));
        this.verifyTransformerExecuted((Transformer)converter1);
    }

    @Test
    public void skipsConverterThatDoesNotMatchWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1});
        Assert.assertTrue((boolean)(message.getPayload() instanceof C));
        this.verifyTransformerNotExecuted((Transformer)converter1);
    }

    @Test
    public void failsTransformationUsingConverterWhenSourceAndReturnTypeDoesNotMatch2() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void appliesBothConverters() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).returning(new C())).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).returning(new D())).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        this.verifyTransformerExecuted((Transformer)converter1);
        this.verifyTransformerExecuted((Transformer)converter2);
    }

    @Test
    public void skipsFirstConverterAppliesSecond() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).returning(new D())).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerExecuted((Transformer)converter2);
    }

    @Test
    public void skipBothConvertersButPayloadMatchesExpectedOutputType() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeC)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new D(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1, converter2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void failsTransformerIgnoringNonMatchingConverter() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void appliesTransformerSkipsConverter() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).returning(new D())).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{transformer1, converter2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        this.verifyTransformerExecuted(transformer1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void failsTransformerIgnoringMatchingConverter() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void failsTransformerIgnoringMatchingConverterWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Converter converter2 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new D(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, converter2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted((Transformer)converter2);
    }

    @Test
    public void skipsConverterFailsOnTransformer() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void appliesConverterFailsOnTransformer() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeD)).returning(new D())).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void skipsConverterAppliesTransformer() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).returning(new D())).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{converter1, transformer2});
        Assert.assertTrue((boolean)(message.getPayload() instanceof D));
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerExecuted(transformer2);
    }

    @Test
    public void skipsConverterFailsOnTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Converter converter1 = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new D(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{converter1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted((Transformer)converter1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void failsOnFirstTransformer() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void appliesFirstTransformerFailsOnSecondTransformer() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).returning(new D())).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerExecuted(transformer1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void failsOnFirstTransformerIgnoresSecondTransformer() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void failsOnFirstTransformerIgnoresSecondTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeD)).build();
        Transformer transformer2 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeC)).to(dataTypeD)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new D(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1, transformer2});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
        this.verifyTransformerNotExecuted(transformer2);
    }

    @Test
    public void failsOnTransformerWhenSourceAndReturnTypeDoesNotMatch() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeC)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new A(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
    }

    @Test
    public void appliesTransformer() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeC)).returning(new C())).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new B(), this.muleContext);
        message.applyTransformers(null, new Transformer[]{transformer1});
        Assert.assertTrue((boolean)(message.getPayload() instanceof C));
        this.verifyTransformerExecuted(transformer1);
    }

    @Test
    public void failsOnTransformerWhenOriginalPayloadMatchesExpectedOutputType() throws MuleException {
        Transformer transformer1 = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(dataTypeB)).to(dataTypeC)).build();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new C(), this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer1});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer1);
    }

    @Test
    public void failsWhenNoImplicitConversionAvailable() throws MuleException {
        Transformer transformer = ((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(DataTypeFactory.BYTE_ARRAY)).to(DataTypeFactory.STRING)).build();
        Mockito.when((Object)this.conversionResolver.resolve((DataType)Mockito.any(DataType.class), Mockito.anyList())).thenReturn(null);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TEST", this.muleContext);
        try {
            message.applyTransformers(null, new Transformer[]{transformer});
            Assert.fail((String)"Transformation is supposed to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.verifyTransformerNotExecuted(transformer);
    }

    @Test
    public void appliesImplicitConversionWhenAvailable() throws MuleException {
        Transformer transformer = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().from(DataTypeFactory.BYTE_ARRAY)).to(DataTypeFactory.STRING)).returning("bar")).build();
        Converter converter = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.STRING)).to(DataTypeFactory.BYTE_ARRAY)).returning("bar".getBytes())).build();
        Mockito.when((Object)this.conversionResolver.resolve((DataType)Mockito.any(DataType.class), Mockito.anyList())).thenReturn((Object)converter);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TEST", this.muleContext);
        message.applyTransformers(null, new Transformer[]{transformer});
        Assert.assertEquals((Object)"bar", (Object)message.getPayload());
        this.verifyTransformerExecuted(transformer);
        this.verifyTransformerExecuted((Transformer)converter);
    }

    private void verifyTransformerNotExecuted(Transformer converter1) throws TransformerException {
        ((Transformer)Mockito.verify((Object)converter1, (VerificationMode)Mockito.times((int)0))).transform(Mockito.any(Object.class));
    }

    private void verifyTransformerExecuted(Transformer converter1) throws TransformerException {
        ((Transformer)Mockito.verify((Object)converter1, (VerificationMode)Mockito.times((int)1))).transform(Mockito.any(Object.class));
    }

    private class D {
        private D() {
        }
    }

    private class C {
        private C() {
        }
    }

    private class B {
        private B() {
        }
    }

    private class A {
        private A() {
        }
    }
}

