/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent.registry;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.BloodOrange;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;

public class MuleRegistryHelperTestCase
extends AbstractMuleContextTestCase {
    private Transformer t1;
    private Transformer t2;

    @Before
    public void setUp() throws Exception {
        this.t1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("t1")).from(DataTypeFactory.create(Orange.class))).to(DataTypeFactory.create(Fruit.class))).build();
        muleContext.getRegistry().registerTransformer(this.t1);
        this.t2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("t2")).from(DataTypeFactory.OBJECT)).to(DataTypeFactory.create(Fruit.class))).build();
        muleContext.getRegistry().registerTransformer(this.t2);
    }

    @Test
    public void lookupsTransformersByType() throws Exception {
        List trans = muleContext.getRegistry().lookupTransformers((DataType)new SimpleDataType(BloodOrange.class), (DataType)new SimpleDataType(Fruit.class));
        Assert.assertEquals((long)2L, (long)trans.size());
        Assert.assertTrue((boolean)trans.contains(this.t1));
        Assert.assertTrue((boolean)trans.contains(this.t2));
    }

    @Test
    public void lookupsTransformerByPriority() throws Exception {
        Transformer result = muleContext.getRegistry().lookupTransformer((DataType)new SimpleDataType(BloodOrange.class), (DataType)new SimpleDataType(Fruit.class));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.t1, (Object)result);
    }
}

