/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.AbstractFlowConstuctTestCase;
import org.mule.construct.Flow;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.transformer.simple.StringAppendTransformer;

public class FlowTestCase
extends AbstractFlowConstuctTestCase {
    private Flow flow;
    private SensingNullMessageProcessor sensingMessageProcessor;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.sensingMessageProcessor = this.getSensingNullMessageProcessor();
        this.flow = new Flow("test-flow", muleContext);
        this.flow.setMessageSource((MessageSource)this.directInboundMessageSource);
        ArrayList<Object> processors = new ArrayList<Object>();
        processors.add(new ResponseMessageProcessorAdapter((MessageProcessor)new StringAppendTransformer("f")));
        processors.add(new ResponseMessageProcessorAdapter((MessageProcessor)new StringAppendTransformer("e")));
        processors.add(new ResponseMessageProcessorAdapter((MessageProcessor)new StringAppendTransformer("d")));
        processors.add(new StringAppendTransformer("a"));
        processors.add(new StringAppendTransformer("b"));
        processors.add(new StringAppendTransformer("c"));
        processors.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("thread", (Object)Thread.currentThread());
                return event;
            }
        });
        processors.add(this.sensingMessageProcessor);
        this.flow.setMessageProcessors(processors);
    }

    @Override
    protected AbstractFlowConstruct getFlowConstruct() throws Exception {
        return this.flow;
    }

    @Test
    public void testProcessOneWayEndpoint() throws Exception {
        this.flow.initialise();
        this.flow.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent((Object)"hello", MessageExchangePattern.ONE_WAY, muleContext));
        Thread.sleep(50L);
        Assert.assertNull((Object)response);
        Assert.assertEquals((Object)"helloabc", (Object)this.sensingMessageProcessor.event.getMessageAsString());
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)this.sensingMessageProcessor.event.getMessage().getOutboundProperty("thread"));
    }

    @Test
    public void testProcessRequestResponseEndpoint() throws Exception {
        this.flow.initialise();
        this.flow.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestEvent((Object)"hello", MessageExchangePattern.REQUEST_RESPONSE, muleContext));
        Assert.assertEquals((Object)"helloabcdef", (Object)response.getMessageAsString());
        Assert.assertEquals((Object)Thread.currentThread(), (Object)response.getMessage().getOutboundProperty("thread"));
        Assert.assertEquals((Object)"helloabcdef", (Object)this.sensingMessageProcessor.event.getMessageAsString());
        Assert.assertEquals((Object)Thread.currentThread(), (Object)this.sensingMessageProcessor.event.getMessage().getOutboundProperty("thread"));
    }

    @Test
    public void testProcessStopped() throws Exception {
        this.flow.initialise();
        try {
            this.directInboundMessageSource.process(MuleTestUtils.getTestEvent("hello", muleContext));
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

