/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.el.context.AbstractELTestCase;

public class MessagePropertiesTestCase
extends AbstractELTestCase {
    public MessagePropertiesTestCase(AbstractELTestCase.Variant variant) {
        super(variant);
    }

    @Test
    public void inboundPropertyMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.INBOUND);
        Assert.assertTrue((boolean)(this.evaluate("message.inboundProperties", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToInboundPropertyMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertFinalProperty("message.inboundProperties='foo'", (MuleMessage)message);
    }

    @Test
    public void inboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.INBOUND);
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.inboundProperties['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToInboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.INBOUND);
        this.assertUnsupportedOperation("message.inboundProperties['foo']='bar'", (MuleMessage)message);
    }

    @Test
    public void assignValueToNewInboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertUnsupportedOperation("message.inboundProperties['foo_new']='bar'", (MuleMessage)message);
    }

    @Test
    public void outboundPropertyMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.OUTBOUND);
        Assert.assertTrue((boolean)(this.evaluate("message.outboundProperties", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToOutboundPropertyMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertFinalProperty("message.outboundProperties='foo'", (MuleMessage)message);
    }

    @Test
    public void outboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.outboundProperties['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToOutboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"bar_old");
        this.evaluate("message.outboundProperties['foo']='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundProperty("foo"));
    }

    @Test
    public void assignValueToNewOutboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.evaluate("message.outboundProperties['foo']='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundProperty("foo"));
    }
}

