/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.transport.PropertyScope;
import org.mule.el.context.AbstractELTestCase;

public class VariablesTestCase
extends AbstractELTestCase {
    public VariablesTestCase(AbstractELTestCase.Variant variant) {
        super(variant);
    }

    @Test
    public void flowVariablesMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.INVOCATION);
        Assert.assertTrue((boolean)(this.evaluate("flowVars", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToFlowVariablesMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertImmutableVariable("flowVars='foo'", (MuleMessage)message);
    }

    @Test
    public void flowVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)event.getFlowVariable("foo"), (Object)this.evaluate("flowVars['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToFlowVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar_old");
        this.evaluate("flowVars['foo']='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)event.getFlowVariable("foo"));
    }

    @Test
    public void assignValueToNewFlowVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        this.evaluate("flowVars['foo']='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)event.getFlowVariable("foo"));
    }

    @Test
    public void sessionVariablesMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)VariablesTestCase.getTestService());
        message.setProperty("foo", (Object)"bar", PropertyScope.SESSION);
        Assert.assertTrue((boolean)(this.evaluate("sessionVars", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToSessionVariablesMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertImmutableVariable("sessionVars='foo'", (MuleMessage)message);
    }

    @Test
    public void sessionVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setSessionVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)event.getSessionVariable("foo"), (Object)this.evaluate("sessionVars['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToSessionVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setSessionVariable("foo", (Object)"bar_old");
        this.evaluate("sessionVars['foo']='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)event.getSessionVariable("foo"));
    }

    @Test
    public void assignValueToNewSessionVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        this.evaluate("sessionVars['foo']='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)event.getSessionVariable("foo"));
    }

    @Test
    public void variableFromFlowScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar");
        event.setSessionVariable("foo", (Object)"NOTbar");
        Assert.assertEquals((Object)event.getFlowVariable("foo"), (Object)this.evaluate("foo", (MuleMessage)message));
    }

    @Test
    public void updateVariableFromFlowScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar_new", (Object)this.evaluate("foo='bar_new'", (MuleMessage)message));
    }

    @Test
    public void variableFromSessionScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setSessionVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)event.getSessionVariable("foo"), (Object)this.evaluate("foo", (MuleMessage)message));
    }

    @Test
    public void updateVariableFromSessionScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setSessionVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar_new", (Object)this.evaluate("foo='bar_new'", (MuleMessage)message));
    }

    @Test
    public void assignValueToVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar_old");
        this.evaluate("foo='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)event.getFlowVariable("foo"));
    }

    @Test
    public void assignValueToLocalVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        this.evaluate("localVar='bar'", (MuleMessage)message);
        Assert.assertNull((Object)event.getFlowVariable("foo"));
    }

    @Test
    public void localVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("localVar='bar';localVar", (MuleMessage)message));
    }
}

