/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.DispatchException;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class DynamicEndpointParsingTestCase
extends AbstractMuleContextTestCase {
    public DynamicEndpointParsingTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testDynamicUriIsProperlyResolvedOnEvent() throws Exception {
        OutboundEndpoint endpoint = this.createRequestResponseEndpoint("test://localhost:#[header:port]");
        Assert.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        MuleEvent event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        MuleEvent response = endpoint.process(event);
        Assert.assertEquals((Object)"test://localhost:12345", (Object)response.getMessageSourceURI().toString());
    }

    @Test
    public void testMissingExpressionResult() throws Exception {
        OutboundEndpoint endpoint = this.createRequestResponseEndpoint("test://#[header:host]:#[header:port]");
        Assert.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        MuleEvent event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        try {
            endpoint.process(event);
            Assert.fail((String)"A required header is missing on the message");
        }
        catch (DispatchException expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof RequiredValueException));
        }
    }

    @Test(expected=MalformedEndpointException.class)
    public void testExpressionInSchemeIsForbidden() throws Exception {
        this.createRequestResponseEndpoint("#[header:scheme]://#[header:host]:#[header:port]");
    }

    @Test(expected=MalformedEndpointException.class)
    public void testMalformedExpressionInUriIsDetected() throws Exception {
        this.createRequestResponseEndpoint("test://#[header:host:#[header:port]");
    }

    @Test(expected=MalformedEndpointException.class)
    public void testDynamicInboundEndpointNotAllowed() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://#[header:host]:#[header:port]", muleContext);
        endpointBuilder.buildInboundEndpoint();
    }

    @Test
    public void testMEPOverridingInUri() throws Exception {
        OutboundEndpoint endpoint = this.createEndpoint("test://#[header:host]:#[header:port]", MessageExchangePattern.ONE_WAY);
        Assert.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        MuleEvent event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        event.getMessage().setOutboundProperty("host", (Object)"localhost");
        MuleEvent response = endpoint.process(event);
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)response);
        endpoint = this.createRequestResponseEndpoint("test://#[header:host]:#[header:port]?exchangePattern=REQUEST_RESPONSE");
        Assert.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        event.getMessage().setOutboundProperty("host", (Object)"localhost");
        response = endpoint.process(event);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)MessageExchangePattern.REQUEST_RESPONSE, (Object)endpoint.getExchangePattern());
    }

    protected OutboundEndpoint createRequestResponseEndpoint(String uri) throws EndpointException, InitialisationException {
        return this.createEndpoint(uri, MessageExchangePattern.REQUEST_RESPONSE);
    }

    private OutboundEndpoint createEndpoint(String uri, MessageExchangePattern exchangePattern) throws EndpointException, InitialisationException {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        endpointBuilder.setExchangePattern(exchangePattern);
        return endpointBuilder.buildOutboundEndpoint();
    }
}

