/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.RequiredValueException;
import org.mule.expression.MessageHeaderExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessageHeaderExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private HashMap<String, Object> messageProperties;
    private MessageHeaderExpressionEvaluator evaluator = new MessageHeaderExpressionEvaluator();
    private MuleMessage message;

    public MessageHeaderExpressionEvaluatorTestCase() {
        this.setDisposeContextPerClass(true);
    }

    @Override
    public void doSetUp() {
        this.messageProperties = new HashMap(3);
        this.messageProperties.put("foo", "foovalue");
        this.messageProperties.put("bar", "barvalue");
        this.messageProperties.put("baz", "bazvalue");
        this.message = new DefaultMuleMessage((Object)"Test Message", this.messageProperties, muleContext);
    }

    @Test
    public void requiredHeaderWithExistingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("foo", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
    }

    @Test
    public void requiredHeaderWithExistingValueViaExpressionManagerShouldReturnValue() {
        Object result = muleContext.getExpressionManager().evaluate("#[header:foo]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredHeaderWithMissingValueShouldFail() {
        this.evaluator.evaluate("nonexistent", this.message);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredHeaderWithMissingValueViaExpressionManagerShouldFail() {
        muleContext.getExpressionManager().evaluate("#[header:fool]", this.message);
    }

    @Test
    public void requiredHeaderWithExplicitPropertyScopeShouldReturnValue() throws Exception {
        this.addInboundMessageProperty("testProp", "testvalue");
        Object result = this.evaluator.evaluate("INBOUND:testProp", this.message);
        Assert.assertEquals((Object)"testvalue", (Object)result);
    }

    @Test
    public void optionalHeaderWithExistingValueShouldReturnValue() {
        Object result = this.evaluator.evaluate("foo?", this.message);
        Assert.assertEquals((Object)"foovalue", (Object)result);
    }

    @Test
    public void optionalHeaderWithExistingValueViaExpressionManagerShouldReturnValue() {
        Object result = muleContext.getExpressionManager().evaluate("#[header:foo?]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foovalue", (Object)result);
    }

    @Test
    public void optionalHeaderWithMissingValueShouldReturnNull() {
        Object result = this.evaluator.evaluate("nonexistent?", this.message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void optionalHeaderWithMissingValueViaExpressionManagerShouldReturnNull() {
        Object result = muleContext.getExpressionManager().evaluate("#[header:nonexistent?]", this.message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void optionalHeaderWithMissingValueInDefaultScopeShouldReturnNull() {
        this.addInboundMessageProperty("testProp", "testvalue");
        Object result = this.evaluator.evaluate("testProp?", this.message);
        Assert.assertNull((Object)result);
    }

    private void addInboundMessageProperty(String key, Object value) {
        Map<String, Object> inboundProperties = Collections.singletonMap(key, value);
        DefaultMuleMessage dmm = (DefaultMuleMessage)this.message;
        dmm.addInboundProperties(inboundProperties);
    }
}

