/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.store.InMemoryObjectStore;

public class InMemoryStoreTestCase
extends AbstractMuleTestCase {
    private InMemoryObjectStore<String> store = null;

    @After
    public void disposeStore() {
        this.store.dispose();
    }

    @Test
    public void testSimpleTimedExpiry() throws Exception {
        int entryTTL = 3000;
        this.createTimedObjectStore(entryTTL);
        this.storeObjects("1", "2", "3");
        this.assertObjectsInStore("1", "2", "3");
        Thread.sleep(entryTTL + 1000);
        this.assertObjectsExpired("1", "2", "3");
    }

    @Test
    public void testComplexTimedExpiry() throws Exception {
        int entryTTL = 3000;
        this.createTimedObjectStore(entryTTL);
        this.storeObjects("1");
        Thread.sleep(entryTTL / 2);
        this.storeObjects("2");
        Thread.sleep(entryTTL / 2 + 500);
        this.assertObjectsExpired("1");
        this.assertObjectsInStore("2");
    }

    @Test
    public void testStoreAndRetrieve() throws Exception {
        String key = "key";
        String value = "hello";
        this.createBoundedObjectStore(1);
        this.store.store((Serializable)((Object)key), (Serializable)((Object)value));
        this.assertObjectsInStore(key);
        String retrieved = (String)((Object)this.store.retrieve((Serializable)((Object)key)));
        Assert.assertEquals((Object)value, (Object)retrieved);
        this.store.remove((Serializable)((Object)key));
        this.assertObjectsExpired(key);
    }

    @Test
    public void testExpiringUnboundedStore() throws Exception {
        this.createUnboundedObjectStore();
        this.storeObjects("1", "2", "3");
        this.store.expire();
        this.assertObjectsInStore("1", "2", "3");
    }

    @Test
    public void testMaxSize() throws Exception {
        int maxEntries = 3;
        this.createBoundedObjectStore(maxEntries);
        this.storeObjects("1", "2", "3");
        this.assertObjectsInStore("1", "2", "3");
        this.store.store((Serializable)((Object)"4"), (Serializable)((Object)"4"));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"1")));
        this.store.expire();
        this.assertObjectsExpired("1");
        this.assertObjectsInStore("2", "3", "4");
        this.storeObjects("5");
        this.store.expire();
        this.assertObjectsExpired("2");
        this.assertObjectsInStore("3", "4", "5");
        this.storeObjects("6", "7", "8", "9");
        this.store.expire();
        this.assertObjectsInStore("7", "8", "9");
        this.assertObjectsExpired("3", "4", "5", "6");
    }

    private void storeObjects(String ... objects) throws Exception {
        for (String entry : objects) {
            this.store.store((Serializable)((Object)entry), (Serializable)((Object)entry));
        }
    }

    private void assertObjectsInStore(String ... identifiers) throws Exception {
        for (String id : identifiers) {
            String message = "id " + id + " not in store " + this.store;
            Assert.assertTrue((String)message, (boolean)this.store.contains((Serializable)((Object)id)));
        }
    }

    private void assertObjectsExpired(String ... identifiers) throws Exception {
        for (String id : identifiers) {
            Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)id)));
        }
    }

    private void createTimedObjectStore(int timeToLive) throws InitialisationException {
        int expireInterval = 1000;
        Assert.assertTrue((String)"objects' time to live must be greater than the expire interval", (timeToLive > expireInterval ? 1 : 0) != 0);
        this.store = new InMemoryObjectStore();
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(timeToLive);
        this.store.setExpirationInterval(expireInterval);
        this.store.initialise();
    }

    private void createBoundedObjectStore(int numberOfEntries) throws InitialisationException {
        this.createNonexpiringObjectStore();
        this.store.setName("bounded");
        this.store.setMaxEntries(numberOfEntries);
        this.store.initialise();
    }

    private void createUnboundedObjectStore() throws InitialisationException {
        this.createNonexpiringObjectStore();
        this.store.setMaxEntries(-1);
        this.store.initialise();
    }

    private void createNonexpiringObjectStore() {
        this.store = new NonExpiringInMemoryObjectStore();
    }

    private static class NonExpiringInMemoryObjectStore
    extends InMemoryObjectStore<String> {
        private CountDownLatch expireLatch;

        public NonExpiringInMemoryObjectStore() {
            this.setEntryTTL(-1);
            this.setExpirationInterval(Integer.MAX_VALUE);
            this.expireLatch = new CountDownLatch(1);
        }

        public void initialise() throws InitialisationException {
            super.initialise();
            try {
                this.expireLatch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Interrupted while waiting for the first expire", ie);
            }
        }

        public void expire() {
            super.expire();
            this.expireLatch.countDown();
        }
    }
}

