/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.TransportFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public final class ConduitInitiatorManagerImpl
implements ConduitInitiatorManager {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ConduitInitiatorManager.class);
    Map<String, ConduitInitiator> conduitInitiators;
    Set<String> failed = new CopyOnWriteArraySet<String>();
    Set<String> loaded = new CopyOnWriteArraySet<String>();
    private Bus bus;

    public ConduitInitiatorManagerImpl() {
        this.conduitInitiators = new ConcurrentHashMap<String, ConduitInitiator>();
    }

    public ConduitInitiatorManagerImpl(Bus b) {
        this.conduitInitiators = new ConcurrentHashMap<String, ConduitInitiator>();
        this.setBus(b);
    }

    public ConduitInitiatorManagerImpl(MapProvider<String, ConduitInitiator> conduitInitiators) {
        this.conduitInitiators = conduitInitiators.createMap();
    }

    public ConduitInitiatorManagerImpl(MapProvider<String, ConduitInitiator> conduitInitiators, Bus b) {
        this.conduitInitiators = conduitInitiators.createMap();
        this.setBus(b);
    }

    public ConduitInitiatorManagerImpl(Map<String, ConduitInitiator> conduitInitiators) {
        this.conduitInitiators = conduitInitiators;
    }

    public ConduitInitiatorManagerImpl(Map<String, ConduitInitiator> conduitInitiators, Bus b) {
        this.conduitInitiators = conduitInitiators;
        this.setBus(b);
    }

    public void setMapProvider(MapProvider<String, ConduitInitiator> mapProvider) {
        this.conduitInitiators = mapProvider.createMap();
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
        if (null != this.bus) {
            this.bus.setExtension((Object)this, ConduitInitiatorManager.class);
        }
    }

    public void registerConduitInitiator(String namespace, ConduitInitiator factory) {
        this.conduitInitiators.put(namespace, factory);
    }

    public void deregisterConduitInitiator(String namespace) {
        this.conduitInitiators.remove(namespace);
    }

    public ConduitInitiator getConduitInitiator(String namespace) throws BusException {
        ConduitInitiator factory = this.conduitInitiators.get(namespace);
        if (factory == null && !this.failed.contains(namespace)) {
            factory = new TransportFinder<ConduitInitiator>(this.bus, this.conduitInitiators, this.loaded, ConduitInitiator.class).findTransportForNamespace(namespace);
        }
        if (factory == null) {
            this.failed.add(namespace);
            throw new BusException(new Message("NO_CONDUIT_INITIATOR", BUNDLE, new Object[]{namespace}));
        }
        return factory;
    }

    @PreDestroy
    public void shutdown() {
    }

    public ConduitInitiator getConduitInitiatorForUri(String uri) {
        ConduitInitiator factory = new TransportFinder<ConduitInitiator>(this.bus, this.conduitInitiators, this.loaded, ConduitInitiator.class).findTransportForURI(uri);
        return factory;
    }
}

