/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl;

import java.beans.ExceptionListener;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.activation.DataSource;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.ParameterParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ibeans.annotation.Call;
import org.ibeans.annotation.State;
import org.ibeans.annotation.Template;
import org.ibeans.api.CallException;
import org.ibeans.api.CallInterceptor;
import org.ibeans.api.DataType;
import org.ibeans.api.IBeanInvocationData;
import org.ibeans.api.IBeanStateData;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.ParamFactoryHolder;
import org.ibeans.api.Request;
import org.ibeans.api.Response;
import org.ibeans.impl.DefaultIBeanConfig;
import org.ibeans.impl.ProcessErrorsInterceptor;
import org.ibeans.impl.support.datatype.DataTypeFactory;
import org.ibeans.impl.support.ds.DataSourceFactory;
import org.ibeans.impl.support.util.UriParamFilter;
import org.ibeans.impl.support.util.Utils;
import org.ibeans.spi.ExpressionParser;
import org.ibeans.spi.IBeansPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalInvocationContext
implements InvocationContext {
    protected final transient Log logger = LogFactory.getLog(InternalInvocationContext.class);
    protected IBeanInvocationData invocationData;
    protected IBeanStateData iBeanStateData;
    protected Method method;
    protected Call call;
    protected Template template;
    protected Boolean stateCall;
    protected Object proxy;
    protected Object[] args;
    protected CallInterceptorChain interceptorChain;
    private Request request;
    private Response response;
    private Object result;
    private Throwable exception;
    protected ExceptionListener exceptionListener;
    protected ExpressionParser expressionParser;
    protected IBeansPlugin plugin;
    protected Class[] paramTypes;

    public InternalInvocationContext(IBeanStateData stateData, Object proxy, Method method, Object[] args, ExceptionListener exceptionListener, List<CallInterceptor> interceptors, IBeansPlugin plugin) throws Exception {
        this.iBeanStateData = stateData;
        this.interceptorChain = new CallInterceptorChain(interceptors);
        this.method = method;
        this.args = args;
        this.proxy = proxy;
        this.exceptionListener = exceptionListener;
        this.plugin = plugin;
        this.expressionParser = plugin.getExpressionParser();
        this.paramTypes = null;
        this.call = method.getAnnotation(Call.class);
        this.template = method.getAnnotation(Template.class);
        this.invocationData = new DefaultIBeanConfig();
        if (this.call == null) {
            return;
        }
        String fullUri = this.call.uri();
        String uri = fullUri.substring(fullUri.indexOf(63) + 1);
        Properties queryParams = Utils.getPropertiesFromQueryString(uri);
        for (String string : queryParams.keySet()) {
            if (this.invocationData.getUriParams().containsKey(string)) continue;
            this.invocationData.getUriParams().put(string, queryParams.getProperty(string));
        }
        if (this.call.properties().length > 0) {
            this.invocationData.getPropertyParams().putAll(Utils.convertKeyValuePairsToMap(this.call.properties()));
        }
        if (this.call.bodyParamFilter().length > 0) {
            for (String bodyParam : this.call.bodyParamFilter()) {
                if (!stateData.getPayloadParams().containsKey(bodyParam)) {
                    throw new IllegalArgumentException("Default BodyParam is not defined: " + bodyParam);
                }
                this.invocationData.addPayloadParam(bodyParam, stateData.getPayloadParams().get(bodyParam));
            }
        }
        if (this.call.headerParamFilter().length > 0) {
            for (String headerParam : this.call.headerParamFilter()) {
                if (!stateData.getHeaderParams().containsKey(headerParam)) {
                    throw new IllegalArgumentException("Default HeaderParam is not defined: " + headerParam);
                }
                this.invocationData.addHeaderParam(headerParam, stateData.getHeaderParams().get(headerParam));
            }
        }
    }

    @Override
    public IBeanStateData getIBeanDefaultConfig() {
        return this.iBeanStateData;
    }

    @Override
    public Map<String, String> getCallSpecificUriParams() {
        if (this.isCallMethod()) {
            Call call = this.getMethod().getAnnotation(Call.class);
            String fullUri = call.uri();
            String uri = fullUri.substring(fullUri.indexOf(63) + 1);
            List queryParams = new ParameterParser().parse(uri, '&');
            TreeMap<String, String> filteredParams = new TreeMap<String, String>();
            for (NameValuePair param : queryParams) {
                filteredParams.put(param.getName(), this.invocationData.getUriParams().get(param.getName()).toString());
            }
            return filteredParams;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> getTemplateSpecificUriParams() {
        if (this.isTemplateMethod()) {
            Template call = this.getMethod().getAnnotation(Template.class);
            String fullUri = call.value();
            String uri = fullUri.substring(fullUri.indexOf(63) + 1);
            if (uri.length() == 0) {
                return Collections.emptyMap();
            }
            List queryParams = new ParameterParser().parse(uri, '&');
            TreeMap<String, String> filteredParams = new TreeMap<String, String>();
            for (NameValuePair param : queryParams) {
                filteredParams.put(param.getName(), (String)this.invocationData.getUriParams().get(param.getName()));
            }
            return filteredParams;
        }
        return Collections.emptyMap();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public IBeanInvocationData getIBeanConfig() {
        return this.invocationData;
    }

    @Override
    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public void setParamTypes(Class[] paramTypes) {
        this.paramTypes = paramTypes;
    }

    @Override
    public Map<String, Object> keysToLowerCase(Map<String, Object> params) {
        TreeMap<String, Object> newMap = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            newMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return newMap;
    }

    @Override
    public Map<String, Object> keysToUpperCase(Map<String, Object> params) {
        TreeMap<String, Object> newMap = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            newMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        return newMap;
    }

    @Override
    public String getParsedCallUri() throws URISyntaxException {
        if (this.call == null) {
            return null;
        }
        return this.getExpressionParser().parseUriTokens(this.invocationData.getUriParams(), this.call.uri());
    }

    @Override
    public ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    @Override
    public String removeQueryParameters(String ... uriParamNames) throws URISyntaxException {
        String uriString = this.getParsedCallUri();
        if (uriString == null) {
            return null;
        }
        UriParamFilter filter = new UriParamFilter();
        for (int i = 0; i < uriParamNames.length; ++i) {
            String uriParamName = uriParamNames[i];
            uriString = filter.filterParamsByValue(uriString, uriParamName);
        }
        return uriString;
    }

    @Override
    public boolean isCallMethod() {
        return this.call != null;
    }

    @Override
    public boolean isTemplateMethod() {
        return this.template != null;
    }

    @Override
    public boolean isStateCall() {
        if (this.stateCall == null) {
            this.stateCall = this.method.getAnnotation(State.class) != null;
        }
        return this.stateCall;
    }

    @Override
    public void proceed() {
        this.interceptorChain.proceed();
    }

    @Override
    public boolean isExceptionThrown() {
        return this.exception != null;
    }

    @Override
    public void rethrowException() throws CallException {
        if (this.exception instanceof CallException) {
            throw (CallException)this.exception;
        }
        this.exception.printStackTrace();
        throw ProcessErrorsInterceptor.createCallException(this, this.exception);
    }

    @Override
    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }

    public void createMessage() throws Exception {
        if (this.getIBeanConfig().getPayloads().size() == 0) {
            if (this.getIBeanConfig().getPayloadParams().size() == 0) {
                this.getIBeanConfig().getPayloads().add("");
            } else {
                this.getIBeanConfig().getPayloads().add(this.getIBeanConfig().getPayloadParams());
            }
        }
        this.createParameters(this.getIBeanDefaultConfig().getUriFactoryParams(), this.getIBeanConfig().getUriParams(), this);
        this.createParameters(this.getIBeanDefaultConfig().getHeaderFactoryParams(), this.getIBeanConfig().getHeaderParams(), this);
        this.createParameters(this.getIBeanDefaultConfig().getPropertyFactoryParams(), this.getIBeanConfig().getPropertyParams(), this);
        this.createParameters(this.getIBeanDefaultConfig().getPayloadFactoryParams(), this.getIBeanConfig().getPayloadParams(), this);
        this.createAttachments(this.getIBeanDefaultConfig().getAttachmentFactoryParams(), this.getIBeanConfig().getAttachments(), this);
        this.request = this.plugin.createRequest(this.getIBeanConfig());
    }

    protected void createAttachments(Set<ParamFactoryHolder> factories, Set<DataSource> attachments, InvocationContext context) throws Exception {
        for (ParamFactoryHolder holder : factories) {
            Object param = holder.getParamFactory().create(holder.getParamName(), false, context);
            if (param == null) continue;
            attachments.add(DataSourceFactory.create(holder.getParamName(), param));
        }
    }

    protected void createParameters(Set<ParamFactoryHolder> factories, Map<String, Object> params, InvocationContext context) throws Exception {
        for (ParamFactoryHolder holder : factories) {
            Object param = holder.getParamFactory().create(holder.getParamName(), false, context);
            if (param == null) continue;
            params.put(holder.getParamName(), param);
        }
    }

    @Override
    public DataType getInvocationReturnType() {
        return this.invocationData.getReturnType();
    }

    @Override
    public void setInvocationReturnType(DataType invocationReturnType) {
        this.invocationData.setReturnType(invocationReturnType);
    }

    @Override
    public DataType<?> getReturnType() {
        if (this.invocationData.getReturnType() != null) {
            return this.invocationData.getReturnType();
        }
        if (this.method.getGenericReturnType() instanceof TypeVariable && this.getIBeanDefaultConfig().getReturnType() != null) {
            return this.getIBeanDefaultConfig().getReturnType();
        }
        return DataTypeFactory.createFromReturnType(this.getMethod());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CallInterceptorChain {
        private List<CallInterceptor> interceptors;
        private int cursor;

        public CallInterceptorChain(List<CallInterceptor> interceptorList) {
            this.interceptors = interceptorList;
        }

        void proceed() {
            if (this.interceptors.size() > this.cursor) {
                CallInterceptor interceptor = this.interceptors.get(this.cursor++);
                try {
                    interceptor.intercept(InternalInvocationContext.this);
                }
                catch (Throwable e) {
                    Throwable root = e;
                    while (root.getCause() != null) {
                        root = root.getCause();
                    }
                    InternalInvocationContext.this.exception = root;
                }
            }
        }
    }
}

