/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.support;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.ibeans.api.IBeansException;
import org.ibeans.impl.support.NamespaceMap;
import org.ibeans.impl.support.XPathFilter;
import org.ibeans.spi.ErrorFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathErrorFilter<Document>
extends XPathFilter<Document>
implements ErrorFilter<Document> {
    private String errorCode;
    private String errorCodeExpression;

    public XPathErrorFilter(String xpath, NamespaceMap namespaces, String errorCodeExpression) throws XPathExpressionException {
        super(xpath, namespaces);
        this.errorCodeExpression = errorCodeExpression;
    }

    @Override
    public boolean accept(Document document) throws IBeansException {
        boolean accept = super.accept(document);
        if (accept && this.errorCodeExpression != null) {
            try {
                this.errorCode = (String)this.xpath.evaluate(this.errorCodeExpression, document, XPathConstants.STRING);
            }
            catch (XPathExpressionException e) {
                throw new IBeansException(e);
            }
        }
        return accept;
    }

    @Override
    public String getErrorCodeExpression() {
        return this.errorCode;
    }

    @Override
    public String getErrorExpression() {
        return this.errorCodeExpression;
    }

    @Override
    public String getType() {
        return "xpath";
    }
}

