/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.support.datatype;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimeTypeParseException;
import org.ibeans.api.DataType;
import org.ibeans.api.channel.MimeType;
import org.ibeans.api.channel.MimeTypes;
import org.ibeans.impl.support.datatype.CollectionDataType;
import org.ibeans.impl.support.datatype.GenericsUtils;
import org.ibeans.impl.support.datatype.ImmutableDataType;
import org.ibeans.impl.support.datatype.MethodParameter;
import org.ibeans.impl.support.datatype.SimpleDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeFactory {
    public static final DataType<String> TEXT_STRING = new SimpleDataType<String>(String.class, MimeTypes.TEXT);
    public static final DataType<String> XML_STRING = new SimpleDataType<String>(String.class, MimeTypes.XML);
    public static final DataType<String> JSON_STRING = new SimpleDataType<String>(String.class, MimeTypes.JSON);
    public static final DataType<String> HTML_STRING = new SimpleDataType<String>(String.class, MimeTypes.HTML);
    public static final DataType<String> ATOM_STRING = new SimpleDataType<String>(String.class, MimeTypes.ATOM);
    public static final DataType<String> RSS_STRING = new SimpleDataType<String>(String.class, MimeTypes.RSS);
    public static final DataType<String> STRING = new SimpleDataType<String>(String.class);
    public static final DataType<String> OBJECT = new SimpleDataType<String>(Object.class);
    public static final DataType<String> BYTE_ARRAY = new SimpleDataType<String>(byte[].class);
    public static final DataType<String> INPUT_STREAM = new SimpleDataType<String>(InputStream.class);

    public static DataType<?> create(Class<?> type) {
        return DataTypeFactory.create(type, MimeTypes.ANY);
    }

    public static DataType<?> createImmutable(Class<?> type) {
        return new ImmutableDataType(DataTypeFactory.create(type, MimeTypes.ANY));
    }

    public static DataType<?> createWithEncoding(Class<?> type, String encoding) {
        DataType<?> dataType = DataTypeFactory.create(type);
        dataType.setEncoding(encoding);
        return dataType;
    }

    public static DataType<?> create(Class<?> type, String mimeType) throws MimeTypeParseException {
        return DataTypeFactory.create(type, new MimeType(mimeType));
    }

    public static DataType<?> create(Class<?> type, MimeType mimeType) {
        if (Collection.class.isAssignableFrom(type)) {
            Class<?> collectionType = type;
            Class<?> itemType = GenericsUtils.getCollectionType(collectionType);
            if (itemType == null) {
                return new CollectionDataType((Class<? extends Collection>)((Class<Collection>)collectionType), mimeType);
            }
            return new CollectionDataType(collectionType, itemType, mimeType);
        }
        if (Proxy.isProxyClass(type)) {
            return new SimpleDataType(type.getInterfaces()[0], mimeType);
        }
        return new SimpleDataType(type, mimeType);
    }

    public static <T> DataType create(Class<? extends Collection> collClass, Class<T> itemType) {
        return DataTypeFactory.create(collClass, itemType, MimeTypes.ANY);
    }

    public static <T> DataType create(Class<? extends Collection> collClass, Class<T> itemType, String mimeType) throws MimeTypeParseException {
        return new CollectionDataType(collClass, itemType, mimeType);
    }

    public static <T> DataType create(Class<? extends Collection> collClass, Class<T> itemType, MimeType mimeType) {
        return new CollectionDataType(collClass, itemType, mimeType);
    }

    public static DataType createFromObject(Object o) throws MimeTypeParseException {
        Class<?> type = o.getClass();
        String mime = null;
        if (o instanceof DataHandler) {
            mime = ((DataHandler)o).getContentType();
        } else if (o instanceof DataSource) {
            mime = ((DataSource)o).getContentType();
        }
        MimeType mimeType = mime != null ? new MimeType(mime) : MimeTypes.ANY;
        return DataTypeFactory.create(type, mimeType);
    }

    public static DataType createFromReturnType(Method m) {
        return DataTypeFactory.createFromReturnType(m, MimeTypes.ANY);
    }

    public static DataType createFromReturnType(Method m, String mimeType) throws MimeTypeParseException {
        return DataTypeFactory.createFromReturnType(m, new MimeType(mimeType));
    }

    public static DataType createFromReturnType(Method m, MimeType mimeType) {
        if (Collection.class.isAssignableFrom(m.getReturnType())) {
            Class<?> cType = m.getReturnType();
            Class<?> itemType = GenericsUtils.getCollectionReturnType(m);
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType((Class<? extends Collection>)((Class<Collection>)cType), mimeType);
        }
        return new SimpleDataType(m.getReturnType(), mimeType);
    }

    public static DataType createFromParameterType(Method m, int paramIndex) {
        return DataTypeFactory.createFromParameterType(m, paramIndex, MimeTypes.ANY);
    }

    public static DataType createFromParameterType(Method m, int paramIndex, String mimeType) throws MimeTypeParseException {
        return DataTypeFactory.createFromParameterType(m, paramIndex, new MimeType(mimeType));
    }

    public static DataType createFromParameterType(Method m, int paramIndex, MimeType mimeType) {
        if (Collection.class.isAssignableFrom(m.getParameterTypes()[paramIndex])) {
            Class<?> cType = m.getParameterTypes()[paramIndex];
            Class<?> itemType = GenericsUtils.getCollectionParameterType(new MethodParameter(m, paramIndex));
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType((Class<? extends Collection>)((Class<Collection>)cType), mimeType);
        }
        return new SimpleDataType(m.getParameterTypes()[paramIndex], mimeType);
    }

    public static DataType createFromField(Field f) {
        return DataTypeFactory.createFromField(f, MimeTypes.ANY);
    }

    public static DataType createFromField(Field f, String mimeType) throws MimeTypeParseException {
        return DataTypeFactory.createFromField(f, new MimeType(mimeType));
    }

    public static DataType createFromField(Field f, MimeType mimeType) {
        if (Collection.class.isAssignableFrom(f.getType())) {
            Class<?> cType = f.getType();
            Class<?> itemType = GenericsUtils.getCollectionFieldType(f);
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType((Class<? extends Collection>)((Class<Collection>)cType), mimeType);
        }
        return new SimpleDataType(f.getType(), mimeType);
    }
}

