/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.view;

import java.lang.reflect.Method;
import java.util.List;
import org.ibeans.annotation.AuthenticationMethod;
import org.ibeans.impl.support.annotation.AnnotationMetaData;
import org.ibeans.impl.view.TemplateView;

public class TextView
extends TemplateView {
    public static final String SPACER = "  ";

    public String createView(Class ibean) {
        Method m;
        super.createView(ibean);
        StringBuffer buf = new StringBuffer();
        if (this.getUsage() != null) {
            buf.append(this.getUsage());
            buf.append("\n");
        } else {
            buf.append("No usage text available for iBean").append("\n");
        }
        buf.append("Short ID: ").append(this.getShortId()).append("\n");
        buf.append("Class: ").append(ibean).append("\n");
        buf.append("Authentication: ").append(this.isAuthentication() ? "Yes" : "No").append("\n");
        String spacer = SPACER;
        if (this.getAuthCalls().size() > 0) {
            buf.append("Authentication Method (Required: Should be called first):\n");
            for (AnnotationMetaData metaData : this.getAuthCalls()) {
                buf.append(this.printMethod((Method)metaData.getMember()));
                buf.append(" [").append(((Method)metaData.getMember()).getAnnotation(AuthenticationMethod.class).value()).append(" Authentication]\n");
            }
        }
        if (this.stateCalls.size() > 0) {
            buf.append("State Methods (Should be called first, may be optional):\n");
            for (AnnotationMetaData metaData : this.getStateCalls()) {
                buf.append(this.printMethod((Method)metaData.getMember())).append("\n");
            }
        }
        buf.append("iBean Methods: \n");
        for (AnnotationMetaData metaData : this.getCalls()) {
            m = (Method)metaData.getMember();
            buf.append(spacer).append("@Call: ").append(m.getReturnType().getSimpleName()).append(" ");
            buf.append(this.printMethod(m)).append("\n");
        }
        for (AnnotationMetaData metaData : this.getTemplates()) {
            m = (Method)metaData.getMember();
            buf.append(spacer).append("@Template: ").append(m.getReturnType().getSimpleName()).append(" ");
            buf.append(this.printMethod(m)).append("\n");
        }
        if (this.getFields().size() > 0) {
            buf.append("Default values:\n");
            for (TemplateView.FieldAnnotation field : this.fields) {
                buf.append(SPACER).append(field.getPrefix()).append(": ");
                buf.append(field.getFieldType().getSimpleName()).append(" ").append(field.getParamName()).append("=").append(field.getFieldValue()).append(" [").append(field.getFieldName()).append("]\n");
            }
        }
        buf.append("\nMethod parameters marked with a '*' are optional, null can be used.\n");
        return buf.toString();
    }

    protected String printMethod(Method method) {
        StringBuffer buf = new StringBuffer();
        buf.append(method.getName());
        List<TemplateView.AnnotationParam> params = this.listParams(method);
        boolean first = true;
        buf.append("(");
        for (TemplateView.AnnotationParam param : params) {
            if (!first) {
                buf.append(", ");
            }
            first = false;
            buf.append(param.getParamType().getSimpleName()).append(" ").append(param.getName());
            if (!param.isOptional()) continue;
            buf.append("*");
        }
        buf.append(")");
        return buf.toString();
    }
}

