/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.model;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.Response;
import org.scribe.model.Verb;
import org.scribe.utils.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Request {
    private static final String CONTENT_LENGTH = "Content-Length";
    private String url;
    private Verb verb;
    private Map<String, String> bodyParams;
    private Map<String, String> headers;
    private String payload = null;
    private Integer timeout = null;
    private HttpURLConnection connection;

    public Request(Verb verb, String url) {
        this.verb = verb;
        this.url = url;
        this.bodyParams = new HashMap<String, String>();
        this.headers = new HashMap<String, String>();
        try {
            this.connection = (HttpURLConnection)new URL(url).openConnection();
            if (this.timeout != null) {
                this.connection.setConnectTimeout(this.timeout);
            }
        }
        catch (IOException ioe) {
            throw new OAuthException("Could not open connection to: " + url, ioe);
        }
    }

    public Response send() {
        try {
            return this.doSend();
        }
        catch (IOException ioe) {
            throw new OAuthException("Problems while creating connection", ioe);
        }
    }

    Response doSend() throws IOException {
        this.connection.setRequestMethod(this.verb.name());
        this.addHeaders(this.connection);
        if (this.verb.equals((Object)Verb.PUT) || this.verb.equals((Object)Verb.POST)) {
            this.addBody(this.connection, this.getBodyContents());
        }
        return new Response(this.connection);
    }

    void addHeaders(HttpURLConnection conn) {
        for (String key : this.headers.keySet()) {
            conn.setRequestProperty(key, this.headers.get(key));
        }
    }

    void addBody(HttpURLConnection conn, String content) throws IOException {
        conn.setRequestProperty(CONTENT_LENGTH, String.valueOf(content.getBytes().length));
        conn.setDoOutput(true);
        conn.getOutputStream().write(content.getBytes());
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addBodyParameter(String key, String value) {
        this.bodyParams.put(key, value);
    }

    public void addPayload(String payload) {
        this.payload = payload;
    }

    public Map<String, String> getQueryStringParams() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String query = new URL(this.url).getQuery();
            if (query != null) {
                for (String param : query.split("&")) {
                    String[] pair = param.split("=");
                    params.put(pair[0], pair[1]);
                }
            }
            return params;
        }
        catch (MalformedURLException mue) {
            throw new OAuthException("Malformed URL", mue);
        }
    }

    public Map<String, String> getBodyParams() {
        return this.bodyParams;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSanitizedUrl() {
        return this.url.replaceAll("\\?.*", "").replace("\\:\\d{4}", "");
    }

    public String getBodyContents() {
        return this.payload != null ? this.payload : URLUtils.formURLEncodeMap(this.bodyParams);
    }

    public Verb getVerb() {
        return this.verb;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    void setConnection(HttpURLConnection connection) {
        this.connection = connection;
    }

    public String toString() {
        return String.format("@Request(%s %s)", new Object[]{this.getVerb(), this.getUrl()});
    }
}

