/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.transport.AbstractMuleMessageFactory;

public class JmsMuleMessageFactory
extends AbstractMuleMessageFactory {
    public JmsMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{Message.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        return transportMessage;
    }

    protected void addProperties(DefaultMuleMessage muleMessage, Object transportMessage) throws Exception {
        Message jmsMessage = (Message)transportMessage;
        HashMap<String, Object> messageProperties = new HashMap<String, Object>();
        this.addCorrelationProperties(jmsMessage, (MuleMessage)muleMessage, messageProperties);
        this.addDeliveryModeProperty(jmsMessage, messageProperties);
        this.addDestinationProperty(jmsMessage, messageProperties);
        this.addExpirationProperty(jmsMessage, messageProperties);
        this.addMessageIdProperty(jmsMessage, messageProperties);
        this.addPriorityProperty(jmsMessage, messageProperties);
        this.addRedeliveredProperty(jmsMessage, messageProperties);
        this.addJMSReplyTo((MuleMessage)muleMessage, jmsMessage);
        this.addTimestampProperty(jmsMessage, messageProperties);
        this.addTypeProperty(jmsMessage, messageProperties);
        this.propagateJMSProperties(jmsMessage, messageProperties);
        muleMessage.addInboundProperties(messageProperties);
    }

    protected void propagateJMSProperties(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            Enumeration e = jmsMessage.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                try {
                    Object value = jmsMessage.getObjectProperty(key);
                    if (value == null) continue;
                    messageProperties.put(key, value);
                }
                catch (JMSException e1) {}
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addTypeProperty(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            String value = jmsMessage.getJMSType();
            if (value != null) {
                messageProperties.put("JMSType", value);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addTimestampProperty(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            long value = jmsMessage.getJMSTimestamp();
            messageProperties.put("JMSTimestamp", value);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addJMSReplyTo(MuleMessage muleMessage, Message jmsMessage) {
        try {
            Destination replyTo = jmsMessage.getJMSReplyTo();
            if (replyTo != null) {
                muleMessage.setOutboundProperty("JMSReplyTo", (Object)replyTo);
            }
            muleMessage.setReplyTo((Object)replyTo);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addRedeliveredProperty(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            boolean value = jmsMessage.getJMSRedelivered();
            messageProperties.put("JMSRedelivered", value);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addPriorityProperty(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            int value = jmsMessage.getJMSPriority();
            messageProperties.put("JMSPriority", value);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addMessageIdProperty(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            String value = jmsMessage.getJMSMessageID();
            if (value != null) {
                messageProperties.put("JMSMessageID", value);
                messageProperties.put("MULE_MESSAGE_ID", value);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addExpirationProperty(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            long value = jmsMessage.getJMSExpiration();
            messageProperties.put("JMSExpiration", value);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addDestinationProperty(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            Destination value = jmsMessage.getJMSDestination();
            if (value != null) {
                messageProperties.put("JMSDestination", value);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addDeliveryModeProperty(Message jmsMessage, Map<String, Object> messageProperties) {
        try {
            int value = jmsMessage.getJMSDeliveryMode();
            messageProperties.put("JMSDeliveryMode", value);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    protected void addCorrelationProperties(Message jmsMessage, MuleMessage muleMessage, Map<String, Object> messageProperties) {
        try {
            String value = jmsMessage.getJMSCorrelationID();
            if (value != null) {
                messageProperties.put("JMSCorrelationID", value);
                messageProperties.put("MULE_CORRELATION_ID", value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
    }
}

